/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.controller;

import edu.colorado.phet.common.controls.SpectrumSliderWithSquareCursor;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.phetcommon.view.controls.IntensitySlider;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.view.MatchState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class BeamControl
extends GraphicLayerSet
implements PhotonSource.RateChangeListener,
PhotonSource.WavelengthChangeListener {
    private ApparatusPanel apparatusPanel;
    private BaseLaserModule baseLaserModule;
    private IntensitySlider intensitySlider;
    private Point intensitySliderRelLoc = new Point(-87, 28);
    private Dimension intensitySliderSize = new Dimension(101, 29);
    private Point intensitySliderLoc;
    private Point spectrumSliderLoc;
    private Point spectrumSliderRelLoc = new Point(-77, 92);
    private Dimension spectrumSize = new Dimension(101, 31);
    private SpectrumSliderWithSquareCursor wavelengthSlider;
    private Beam beam;

    public BeamControl(ApparatusPanel apparatusPanel, BaseLaserModule baseLaserModule, Point point, Beam beam, double d, double d2, BufferedImage bufferedImage) {
        this.apparatusPanel = apparatusPanel;
        this.baseLaserModule = baseLaserModule;
        this.beam = beam;
        this.setLocation(point);
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic((Component)apparatusPanel, bufferedImage);
        phetImageGraphic.setRegistrationPoint(100, 0);
        this.addGraphic(phetImageGraphic);
        phetImageGraphic.setLocation(0, 0);
        this.intensitySliderLoc = new Point(point.x + this.intensitySliderRelLoc.x, point.y + this.intensitySliderRelLoc.y);
        this.spectrumSliderLoc = new Point((int)this.spectrumSliderRelLoc.getX(), (int)this.spectrumSliderRelLoc.getY());
        this.addWavelengthSlider(beam, d, d2);
        this.addIntensitySlider(beam, beam.getMaxPhotonsPerSecond());
        beam.addRateChangeListener(this);
    }

    private void addWavelengthSlider(final Beam beam, double d, double d2) {
        this.wavelengthSlider = new SpectrumSliderWithSquareCursor(this.apparatusPanel, d, d2);
        this.wavelengthSlider.setLocation(this.spectrumSliderLoc);
        this.wavelengthSlider.setOrientation(0);
        this.wavelengthSlider.setTransmissionWidth(1.0);
        this.wavelengthSlider.setKnobSize(new Dimension(15, 12));
        this.wavelengthSlider.setSpectrumSize(this.spectrumSize);
        this.addGraphic(this.wavelengthSlider, 100.0);
        this.wavelengthSlider.setValue((int)beam.getWavelength());
        this.wavelengthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = BeamControl.this.wavelengthSlider.getValue();
                beam.setWavelength(n);
            }
        });
        this.wavelengthSlider.addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                BeamControl.this.handleMatch();
            }
        });
        this.wavelengthSlider.setValue((int)beam.getWavelength());
    }

    private void handleMatch() {
        MatchState matchState = this.baseLaserModule.getMatch(this.beam);
        if (matchState != null) {
            double d = matchState.getTransitionEnergy();
            double d2 = PhysicsUtil.energyToWavelength(Math.abs(d));
            System.out.println("exactTransitionEnergy = " + d + ", wavelength=" + d2);
            this.beam.setWavelength(d2);
        }
    }

    private void addIntensitySlider(final Beam beam, double d) {
        this.intensitySlider = new IntensitySlider(VisibleColor.wavelengthToColor(beam.getWavelength()), IntensitySlider.HORIZONTAL, this.intensitySliderSize);
        this.intensitySlider.setMaximum((int)d);
        this.intensitySlider.setLocation((int)(this.intensitySliderLoc.getX() - this.getRegistrationPoint().getX()), (int)(this.intensitySliderLoc.getY() - this.getRegistrationPoint().getY()));
        this.apparatusPanel.add(this.intensitySlider);
        this.intensitySlider.setValue(0);
        this.intensitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                beam.setPhotonsPerSecond(BeamControl.this.intensitySlider.getValue());
            }
        });
        beam.addWavelengthChangeListener(new WavelengthChangeListener());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.intensitySlider.setVisible(bl);
    }

    public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
        this.intensitySlider.setValue((int)rateChangeEvent.getRate());
    }

    public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
    }

    public class WavelengthChangeListener
    implements PhotonSource.WavelengthChangeListener {
        public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
            BeamControl.this.intensitySlider.setColor(VisibleColor.wavelengthToColor(wavelengthChangeEvent.getWavelength()));
            if (BeamControl.this.wavelengthSlider.getValue() != (int)wavelengthChangeEvent.getWavelength()) {
                BeamControl.this.wavelengthSlider.setValue((int)wavelengthChangeEvent.getWavelength());
            }
        }
    }
}

