/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;
import java.awt.Component;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class CircuitGraphic
extends PhetImageGraphic
implements DischargeLampModel.ChangeListener {
    private BufferedImage positiveVoltageImage = DischargeLampsResources.getImage("battery-w-wires-2.png");
    private BufferedImage negativeVoltageImage = DischargeLampsResources.getImage("battery-w-wires-2a.png");
    private BufferedImage currImage;

    public CircuitGraphic(Component component, AffineTransformOp affineTransformOp) {
        super(component);
        this.positiveVoltageImage = affineTransformOp.filter(this.positiveVoltageImage, null);
        this.negativeVoltageImage = affineTransformOp.filter(this.negativeVoltageImage, null);
        this.currImage = this.positiveVoltageImage;
        this.setImage(this.currImage);
    }

    public void energyLevelsChanged(DischargeLampModel.ChangeEvent changeEvent) {
    }

    public void voltageChanged(DischargeLampModel.ChangeEvent changeEvent) {
        if (changeEvent.getDischargeLampModel().getVoltage() > 0.0 && this.currImage != this.positiveVoltageImage) {
            this.currImage = this.positiveVoltageImage;
            this.setImage(this.currImage);
            this.setBoundsDirty();
            this.repaint();
        }
        if (changeEvent.getDischargeLampModel().getVoltage() < 0.0 && this.currImage != this.negativeVoltageImage) {
            this.currImage = this.negativeVoltageImage;
            this.setImage(this.currImage);
            this.setBoundsDirty();
            this.repaint();
        }
    }

    public void currentChanged(DischargeLampModel.ChangeEvent changeEvent) {
    }
}

