/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.dischargelamps.DischargeLampModule;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.control.ElectronProductionControl;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;
import edu.colorado.phet.dischargelamps.view.CollisionEnergyIndicator;
import edu.colorado.phet.dischargelamps.view.DischargeLampEnergyMonitorPanel2;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.view.AtomGraphic;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

public class SingleAtomModule
extends DischargeLampModule {
    private DischargeLampAtom atom;
    private double maxCurrent = 3.0;
    private CollisionEnergyIndicator collisionEnergyIndicatorGraphic;

    protected SingleAtomModule(String string, IClock iClock) {
        super(string, iClock);
        this.addAtom(this.getTube());
        this.setElectronProductionMode(ElectronProductionControl.SINGLE_SHOT);
        this.getDischargeLampModel().setMaxCurrent(this.getMaxCurrent());
        this.getDischargeLampModel().getLeftHandPlate().setEmittingLength(1.0);
        this.getDischargeLampModel().getRightHandPlate().setEmittingLength(1.0);
        this.addControls();
        this.setSquigglesEnabled(true);
    }

    protected double getMaxCurrent() {
        return 25.0;
    }

    private void addControls() {
        DischargeLampEnergyMonitorPanel2 dischargeLampEnergyMonitorPanel2 = super.getEneregyLevelsMonitorPanel();
        this.collisionEnergyIndicatorGraphic = new CollisionEnergyIndicator(dischargeLampEnergyMonitorPanel2.getElmp(), this);
        dischargeLampEnergyMonitorPanel2.getElmp().addGraphic(this.collisionEnergyIndicatorGraphic, -1.0);
        this.collisionEnergyIndicatorGraphic.setEnabled(false);
        this.atom.addElectronCollisionListener(new DischargeLampAtom.ElectronCollisionListener(){

            public void collisionOccurred(DischargeLampAtom.ElectronCollisionEvent electronCollisionEvent) {
                SingleAtomModule.this.collisionEnergyIndicatorGraphic.setEnabled(true);
                electronCollisionEvent.getAtom().removeElectronCollisionListener(this);
            }
        });
        HTMLGraphic hTMLGraphic = new HTMLGraphic(dischargeLampEnergyMonitorPanel2, new PhetFont(12, true), DischargeLampsResources.getString("Misc.groundState"), Color.black);
        hTMLGraphic.translate(110.0, 278 - hTMLGraphic.getHeight() / 2);
        dischargeLampEnergyMonitorPanel2.getElmp().addGroundStateLabel(hTMLGraphic, -1);
        dischargeLampEnergyMonitorPanel2.getElmp().setPreferredSize(new Dimension(200, 300));
    }

    private void addAtom(Tube tube) {
        Rectangle2D rectangle2D = tube.getBounds();
        this.atom = new DischargeLampAtom((LaserModel)this.getModel(), this.getDischargeLampModel().getElementProperties());
        this.atom.setPosition(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        AtomGraphic atomGraphic = this.addAtom(this.atom);
        this.getApparatusPanel().removeGraphic(atomGraphic);
        this.getApparatusPanel().addGraphic(atomGraphic, 121.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getMinX() + this.atom.getRadius(), rectangle2D.getMinY() + this.atom.getRadius(), rectangle2D.getWidth() - this.atom.getRadius() * 2.0, rectangle2D.getHeight() - this.atom.getRadius() * 2.0);
        atomGraphic.setIsMouseable(true, double_);
        atomGraphic.setCursorHand();
        this.getEneregyLevelsMonitorPanel().reset();
    }

    public Atom getAtom() {
        return this.atom;
    }
}

