/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.phetgraphics;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class PhetTextGraphic2
extends PhetGraphic {
    private static final Font DEFAULT_FONT = new PhetFont(0, 12);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private Font font;
    private String text;
    private Color color;
    private FontMetrics fontMetrics;
    private int justification;

    public PhetTextGraphic2(Component component, Font font, String string, Color color, int n, int n2) {
        super(component);
        this.setFont(font);
        this.text = string;
        this.color = color;
        this.setJustification(0);
        this.setLocation(n, n2);
    }

    public PhetTextGraphic2(Component component, Font font, String string, Color color) {
        this(component, font, string, color, 0, 0);
    }

    public PhetTextGraphic2() {
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = this.getComponent().getFontMetrics(font);
        this.setJustification(this.justification);
        this.setBoundsDirty();
        this.autorepaint();
    }

    public void setJustification(int n) {
        this.justification = n;
        int n2 = this.fontMetrics.getAscent();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.setRegistrationPoint(0, 0);
                break;
            }
            case 2: {
                this.setRegistrationPoint(this.getWidth() / 2, 0);
                break;
            }
            case 3: {
                this.setRegistrationPoint(this.getWidth(), 0);
                break;
            }
            case 5: {
                this.setRegistrationPoint(this.getWidth(), n2);
                break;
            }
            case 6: {
                this.setRegistrationPoint(this.getWidth() / 2, n2);
                break;
            }
            case 7: {
                this.setRegistrationPoint(0, n2);
                break;
            }
            case 4: {
                this.setRegistrationPoint(this.getWidth(), n2 / 2);
                break;
            }
            case 8: {
                this.setRegistrationPoint(0, n2 / 2);
                break;
            }
            case 9: {
                this.setRegistrationPoint(this.getWidth() / 2, n2 / 2);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid justification: " + n);
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            super.updateGraphicsState(graphics2D);
            graphics2D.setFont(this.font);
            graphics2D.setColor(this.color);
            graphics2D.transform(this.getNetTransform());
            graphics2D.drawString(this.text, 0, this.fontMetrics.getAscent());
            super.restoreGraphicsState();
        }
    }

    protected Rectangle determineBounds() {
        if (this.text == null || this.text.equals("")) {
            return null;
        }
        int n = this.fontMetrics.stringWidth(this.text);
        int n2 = this.fontMetrics.getHeight();
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        return this.getNetTransform().createTransformedShape(rectangle).getBounds();
    }
}

