/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.phetgraphics;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class HTMLGraphic
extends CompositePhetGraphic {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final Font DEFAULT_FONT = new PhetFont(0, 12);
    private String html;
    private Font font;
    private Color color;
    private PhetImageGraphic imageGraphic;

    public HTMLGraphic(Component component, Font font, String string, Color color) {
        super(component);
        this.html = this.makeHTML(string);
        this.font = font;
        this.color = color;
        this.imageGraphic = new PhetImageGraphic(component, null, 0, 0);
        this.addGraphic(this.imageGraphic);
        this.update();
    }

    private String makeHTML(String string) {
        String string2 = string;
        if (!BasicHTML.isHTMLString(string)) {
            string2 = "<html>" + string + "</html>";
        }
        return string2;
    }

    public void update() {
        this.imageGraphic.setImage(HTMLRenderer.render(this.color, this.font, this.html));
        this.setBoundsDirty();
        this.autorepaint();
    }

    private static class HTMLRenderer {
        public static BufferedImage render(Color color, Font font, String string) {
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            jLabel.setForeground(color);
            View view = BasicHTML.createHTMLView(jLabel, string);
            Dimension dimension = jLabel.getPreferredSize();
            if (dimension.width == 0 || dimension.height == 0) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(new Color(255, 255, 255, 0));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Rectangle rectangle = new Rectangle(dimension);
            graphics2D.fill(rectangle);
            graphics2D.setClip(rectangle);
            view.paint(graphics2D, rectangle);
            return bufferedImage;
        }
    }
}

