/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.DataSetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class ScatterPlot
extends DataSetGraphic {
    private GraphicLayerSet points;
    private ScatterPaintFactory scatterPaintFactory;

    public ScatterPlot(Component component, Chart chart, DataSet dataSet, Color color, int n) {
        this(component, chart, dataSet, new CircleFactory(component, color, n));
    }

    public ScatterPlot(Component component, Chart chart, DataSet dataSet, ScatterPaintFactory scatterPaintFactory) {
        super(component, chart, dataSet);
        this.scatterPaintFactory = scatterPaintFactory;
        this.points = new GraphicLayerSet();
        this.addGraphic(this.points);
        this.addAllPoints();
    }

    public void transformChanged() {
        this.points.clear();
        this.addAllPoints();
    }

    public void pointAdded(Point2D point2D) {
        Point2D point2D2 = this.getChart().transformDouble(point2D);
        this.points.addGraphic(this.scatterPaintFactory.createScatterPoint(point2D2.getX(), point2D2.getY()));
    }

    public void cleared() {
        this.points.clear();
    }

    public void pointsAdded(Point2D[] point2DArray) {
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = point2DArray[i];
            this.pointAdded(point2D);
        }
    }

    public static class CircleFactory
    implements ScatterPaintFactory {
        private Component component;
        private Color color;
        private int radius;

        public CircleFactory(Component component, Color color, int n) {
            this.component = component;
            this.color = color;
            this.radius = n;
        }

        public PhetGraphic createScatterPoint(double d, double d2) {
            Ellipse2D.Double double_ = new Ellipse2D.Double(d - (double)this.radius, d2 - (double)this.radius, this.radius * 2, this.radius * 2);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.component, double_, this.color);
            return phetShapeGraphic;
        }
    }

    public static interface ScatterPaintFactory {
        public PhetGraphic createScatterPoint(double var1, double var3);
    }
}

