/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import java.awt.geom.Point2D;
import java.util.ArrayList;

public class DataSet {
    private ArrayList dataPoints = new ArrayList();
    private ArrayList observers = new ArrayList();

    public void clear() {
        this.dataPoints.clear();
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.cleared();
        }
    }

    public Point2D[] getPoints() {
        return this.dataPoints.toArray(new Point2D[0]);
    }

    public boolean isValid(Point2D point2D) {
        if (point2D == null) {
            return false;
        }
        boolean bl = Double.isNaN(point2D.getX()) || Double.isNaN(point2D.getY()) || Double.isInfinite(point2D.getX()) || Double.isInfinite(point2D.getY());
        return !bl;
    }

    public void addPoint(Point2D point2D) {
        if (!this.isValid(point2D)) {
            throw new RuntimeException("Illegal data point: " + point2D);
        }
        if (point2D == null) {
            throw new RuntimeException("Null data Point");
        }
        this.dataPoints.add(point2D);
        this.notifyObservers(point2D);
    }

    public void addPoint(double d, double d2) {
        this.addPoint(new Point2D.Double(d, d2));
    }

    private void notifyObservers(Point2D point2D) {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.pointAdded(point2D);
        }
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public void removeObserver(Observer observer) {
        this.observers.remove(observer);
    }

    public String toString() {
        return this.dataPoints.toString();
    }

    public static interface Observer {
        public void cleared();

        public void pointAdded(Point2D var1);

        public void pointsAdded(Point2D[] var1);
    }
}

