/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ReflectionDBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBCollection {
    final DB _db;
    protected final String _name;
    protected final String _fullName;
    private WriteConcern _concern = null;
    private ReadPreference _readPref = null;
    private DBDecoderFactory _decoderFactory;
    private DBEncoderFactory _encoderFactory;
    final Bytes.OptionHolder _options;
    protected Class _objectClass = null;
    private Map<String, Class> _internalClass = Collections.synchronizedMap(new HashMap());
    private ReflectionDBObject.JavaWrapper _wrapper = null;
    private final Set<String> _createdIndexes = new HashSet<String>();

    public WriteResult insert(DBObject[] arr, WriteConcern concern) throws MongoException {
        return this.insert(arr, concern, this.getDBEncoderFactory().create());
    }

    public abstract WriteResult insert(DBObject[] var1, WriteConcern var2, DBEncoder var3) throws MongoException;

    public WriteResult insert(DBObject ... arr) throws MongoException {
        return this.insert(arr, this.getWriteConcern());
    }

    protected abstract void doapply(DBObject var1);

    abstract Iterator<DBObject> __find(DBObject var1, DBObject var2, int var3, int var4, int var5, int var6, ReadPreference var7, DBDecoder var8) throws MongoException;

    public final Object apply(DBObject o) {
        return this.apply(o, true);
    }

    public final Object apply(DBObject jo, boolean ensureID) {
        Object id = jo.get("_id");
        if (ensureID && id == null) {
            id = ObjectId.get();
            jo.put("_id", id);
        }
        this.doapply(jo);
        return id;
    }

    protected DBCollection(DB base, String name) {
        this._db = base;
        this._name = name;
        this._fullName = this._db.getName() + "." + name;
        this._options = new Bytes.OptionHolder(this._db._options);
        this._decoderFactory = this._db.getMongo().getMongoOptions().dbDecoderFactory;
        this._encoderFactory = this._db.getMongo().getMongoOptions().dbEncoderFactory;
    }

    protected DBObject _checkObject(DBObject o, boolean canBeNull, boolean query) {
        if (o == null) {
            if (canBeNull) {
                return null;
            }
            throw new IllegalArgumentException("can't be null");
        }
        if (o.isPartialObject() && !query) {
            throw new IllegalArgumentException("can't save partial objects");
        }
        if (!query) {
            this._checkKeys(o);
        }
        return o;
    }

    private void _checkKeys(DBObject o) {
        for (String s : o.keySet()) {
            this.validateKey(s);
            Object inner = o.get(s);
            if (inner instanceof DBObject) {
                this._checkKeys((DBObject)inner);
                continue;
            }
            if (!(inner instanceof Map)) continue;
            this._checkKeys((Map)inner);
        }
    }

    private void _checkKeys(Map<String, Object> o) {
        for (String s : o.keySet()) {
            this.validateKey(s);
            Object inner = o.get(s);
            if (inner instanceof DBObject) {
                this._checkKeys((DBObject)inner);
                continue;
            }
            if (!(inner instanceof Map)) continue;
            this._checkKeys((Map)inner);
        }
    }

    private void validateKey(String s) {
        if (s.contains(".")) {
            throw new IllegalArgumentException("fields stored in the db can't have . in them. (Bad Key: '" + s + "')");
        }
        if (s.startsWith("$")) {
            throw new IllegalArgumentException("fields stored in the db can't start with '$' (Bad Key: '" + s + "')");
        }
    }

    public DB getDB() {
        return this._db;
    }

    public int hashCode() {
        return this._fullName.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public String toString() {
        return this._name;
    }

    protected Class getInternalClass(String path) {
        Class c = this._internalClass.get(path);
        if (c != null) {
            return c;
        }
        if (this._wrapper == null) {
            return null;
        }
        return this._wrapper.getInternalClass(path);
    }

    public WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._db.getWriteConcern();
    }

    public DBEncoderFactory getDBEncoderFactory() {
        return this._encoderFactory;
    }
}

