/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.particle;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.util.PhotonImageFactory;
import edu.colorado.phet.hydrogenatom.model.Photon;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Image;
import java.util.Observable;
import java.util.Observer;

public class PhotonNode
extends PhetPNode
implements Observer {
    private Photon _photon;

    public PhotonNode(Photon photon) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        Image image = PhotonImageFactory.lookupPhotonImage(photon.getWavelength(), 30.0);
        PImage pImage = new PImage(image);
        this.addChild(pImage);
        pImage.setOffset(-pImage.getFullBounds().getWidth() / 2.0, -pImage.getFullBounds().getHeight() / 2.0);
        this._photon = photon;
        this._photon.addObserver(this);
    }

    public void update(Observable observable, Object object) {
        this.update();
    }

    private void update() {
        this.setRotation(this._photon.getOrientation());
        this.setOffset(HAModelViewTransform.transform(this._photon.getPositionRef()));
    }
}

