/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.model.SolarSystemModel;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.colorado.phet.hydrogenatom.view.OriginNode;
import edu.colorado.phet.hydrogenatom.view.atom.AbstractHydrogenAtomNode;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.colorado.phet.hydrogenatom.view.particle.ProtonNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;

public class SolarSystemNode
extends AbstractHydrogenAtomNode
implements Observer {
    private SolarSystemModel _atom;
    private ProtonNode _protonNode;
    private ElectronNode _electronNode;
    private PImage _kaboomNode;

    public SolarSystemNode(SolarSystemModel solarSystemModel) {
        this._atom = solarSystemModel;
        this._atom.addObserver(this);
        this._protonNode = new ProtonNode();
        this._electronNode = new ElectronNode();
        this._kaboomNode = HAResources.getImageNode("kaboom.png");
        this._kaboomNode.setVisible(false);
        this._kaboomNode.setOffset(-this._kaboomNode.getWidth() / 2.0, -this._kaboomNode.getHeight() / 2.0);
        this.addChild(this._protonNode);
        this.addChild(this._electronNode);
        this.addChild(this._kaboomNode);
        OriginNode originNode = new OriginNode(Color.GREEN);
        Point2D point2D = this._atom.getPositionRef();
        Point2D point2D2 = HAModelViewTransform.transform(point2D);
        this.setOffset(point2D2);
        this.update(this._atom, "electronOffset");
    }

    public void update(Observable observable, Object object) {
        if (observable == this._atom) {
            if (object == "electronOffset") {
                Point2D point2D = this._atom.getElectronOffset();
                double d = HAModelViewTransform.transform(point2D.getX());
                double d2 = HAModelViewTransform.transform(point2D.getY());
                this._electronNode.setOffset(d, d2);
            } else if (object == "atomDestroyed") {
                this._protonNode.setVisible(false);
                this._electronNode.setVisible(false);
                this._kaboomNode.setVisible(true);
            }
        }
    }
}

