/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.model.PlumPuddingModel;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.colorado.phet.hydrogenatom.view.atom.AbstractHydrogenAtomNode;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;

public class PlumPuddingNode
extends AbstractHydrogenAtomNode
implements Observer {
    private PlumPuddingModel _atom;
    private ElectronNode _electronNode;

    public PlumPuddingNode(PlumPuddingModel plumPuddingModel) {
        this._atom = plumPuddingModel;
        this._atom.addObserver(this);
        PImage pImage = HAResources.getImageNode("plumPudding.png");
        double d = pImage.getHeight();
        double d2 = 2.0 * HAModelViewTransform.transform(plumPuddingModel.getRadius());
        double d3 = d2 / d;
        pImage.scale(d3);
        this._electronNode = new ElectronNode();
        this.addChild(pImage);
        this.addChild(this._electronNode);
        PBounds pBounds = pImage.getFullBounds();
        pImage.setOffset(-pBounds.getWidth() / 2.0, -pBounds.getHeight() / 2.0);
        Point2D point2D = this._atom.getPositionRef();
        Point2D point2D2 = HAModelViewTransform.transform(point2D);
        this.setOffset(point2D2);
        this.update(this._atom, "electronOffset");
    }

    public void update(Observable observable, Object object) {
        if (observable == this._atom) {
            if (object == "electronOffset") {
                Point2D point2D = this._atom.getElectronOffsetRef();
                double d = HAModelViewTransform.transform(point2D.getX());
                double d2 = HAModelViewTransform.transform(point2D.getY());
                this._electronNode.setOffset(d, d2);
            } else if (object == "atomIonized") {
                // empty if block
            }
        }
    }
}

