/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

class OrbitNodeFactory {
    private static final Color ORBIT_COLOR = Color.WHITE;
    private static final Stroke ORBIT_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);

    public static Color getOrbitColor() {
        return ORBIT_COLOR;
    }

    public static PPath createOrbitNode(double d) {
        return OrbitNodeFactory.createOrbitNodeProjection(d, 1.0);
    }

    public static PPath createOrbitNodeProjection(double d, double d2) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d, -d * d2, 2.0 * d, 2.0 * d * d2);
        PPath pPath = new PPath();
        pPath.setPathTo(double_);
        pPath.setStroke(ORBIT_STROKE);
        pPath.setStrokePaint(ORBIT_COLOR);
        pPath.setPickable(false);
        pPath.setChildrenPickable(false);
        return pPath;
    }
}

