/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.enums.DeBroglieView;
import edu.colorado.phet.hydrogenatom.model.DeBroglieModel;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.colorado.phet.hydrogenatom.view.atom.AbstractHydrogenAtomNode;
import edu.colorado.phet.hydrogenatom.view.atom.DeBroglieBrightnessMagnitudeNode;
import edu.colorado.phet.hydrogenatom.view.atom.DeBroglieBrightnessNode;
import edu.colorado.phet.hydrogenatom.view.atom.DeBroglieHeight3DNode;
import edu.colorado.phet.hydrogenatom.view.atom.DeBroglieRadialDistanceNode;
import edu.colorado.phet.hydrogenatom.view.atom.OrbitNodeFactory;
import edu.colorado.phet.hydrogenatom.view.atom.StateDisplayNode;
import edu.colorado.phet.hydrogenatom.view.particle.ProtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;

public class DeBroglieNode
extends AbstractHydrogenAtomNode
implements Observer {
    private DeBroglieModel _atom;
    private AbstractDeBroglieViewStrategy _viewStrategy;
    private StateDisplayNode _stateNode;

    public DeBroglieNode(DeBroglieModel deBroglieModel) {
        this._atom = deBroglieModel;
        this._atom.addObserver(this);
        this._viewStrategy = DeBroglieNode.createViewStrategy(this._atom);
        this.addChild(this._viewStrategy);
        this._stateNode = new StateDisplayNode();
        this._stateNode.setState(deBroglieModel.getElectronState());
        this.addChild(this._stateNode);
        double d = HAConstants.ANIMATION_BOX_SIZE.getWidth() / 2.0 - this._stateNode.getFullBounds().getWidth() - 15.0;
        double d2 = HAConstants.ANIMATION_BOX_SIZE.getHeight() / 2.0 - this._stateNode.getFullBounds().getHeight() - 15.0;
        this._stateNode.setOffset(d, d2);
        Point2D point2D = deBroglieModel.getPositionRef();
        Point2D point2D2 = HAModelViewTransform.transform(point2D);
        this.setOffset(point2D2);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._atom) {
            if (object == "electronState") {
                this._viewStrategy.update();
                if (this._stateNode != null) {
                    this._stateNode.setState(this._atom.getElectronState());
                }
            } else if (object == "electronOffset") {
                this._viewStrategy.update();
            } else if (object != "atomIonized" && object == "view") {
                this.removeChild(this._viewStrategy);
                this._viewStrategy = DeBroglieNode.createViewStrategy(this._atom);
                this.addChild(this._viewStrategy);
            }
        }
    }

    private static AbstractDeBroglieViewStrategy createViewStrategy(DeBroglieModel deBroglieModel) {
        AbstractDeBroglieViewStrategy abstractDeBroglieViewStrategy = null;
        DeBroglieView deBroglieView = deBroglieModel.getView();
        if (deBroglieView == DeBroglieView.BRIGHTNESS_MAGNITUDE) {
            abstractDeBroglieViewStrategy = new DeBroglieBrightnessMagnitudeNode(deBroglieModel);
        } else if (deBroglieView == DeBroglieView.BRIGHTNESS) {
            abstractDeBroglieViewStrategy = new DeBroglieBrightnessNode(deBroglieModel);
        } else if (deBroglieView == DeBroglieView.RADIAL_DISTANCE) {
            abstractDeBroglieViewStrategy = new DeBroglieRadialDistanceNode(deBroglieModel);
        } else if (deBroglieView == DeBroglieView.HEIGHT_3D) {
            abstractDeBroglieViewStrategy = new DeBroglieHeight3DNode(deBroglieModel);
        } else {
            throw new UnsupportedOperationException("unsupported DeBroglieView: " + (Object)((Object)deBroglieView));
        }
        return abstractDeBroglieViewStrategy;
    }

    public static abstract class AbstractDeBroglie2DViewStrategy
    extends AbstractDeBroglieViewStrategy {
        public AbstractDeBroglie2DViewStrategy(DeBroglieModel deBroglieModel) {
            super(deBroglieModel);
            this.initStaticNodes();
        }

        private void initStaticNodes() {
            this.getAtom();
            int n = DeBroglieModel.getGroundState();
            this.getAtom();
            int n2 = DeBroglieModel.getNumberOfStates();
            for (int i = n; i < n + n2; ++i) {
                this.getAtom();
                double d = HAModelViewTransform.transform(DeBroglieModel.getOrbitRadius(i));
                PPath pPath = OrbitNodeFactory.createOrbitNode(d);
                this.addChild(pPath);
            }
            ProtonNode protonNode = new ProtonNode();
            protonNode.setOffset(0.0, 0.0);
            this.addChild(protonNode);
        }
    }

    public static abstract class AbstractDeBroglieViewStrategy
    extends PNode {
        private DeBroglieModel _atom;

        public AbstractDeBroglieViewStrategy(DeBroglieModel deBroglieModel) {
            this.setPickable(false);
            this.setChildrenPickable(false);
            this._atom = deBroglieModel;
        }

        protected DeBroglieModel getAtom() {
            return this._atom;
        }

        public abstract void update();
    }
}

