/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.hydrogenatom.model.DeBroglieModel;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.colorado.phet.hydrogenatom.view.atom.DeBroglieNode;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class DeBroglieBrightnessNode
extends DeBroglieNode.AbstractDeBroglie2DViewStrategy {
    public static Color PLUS_COLOR = ElectronNode.getColor();
    public static Color MINUS_COLOR = Color.BLACK;
    public static Color ZERO_COLOR = ColorUtils.interpolateRBGA(MINUS_COLOR, PLUS_COLOR, 0.5);
    private PNode _ringNode = new PNode();
    private ArrayList _polygons = new ArrayList();
    private int _previousState = DeBroglieModel.getGroundState() - 1;
    private GeneralPath[] _pathShapes;
    private PPath[] _pathNodes;

    public DeBroglieBrightnessNode(DeBroglieModel deBroglieModel) {
        super(deBroglieModel);
        this.addChild(this._ringNode);
        int n = DeBroglieModel.getGroundState() + DeBroglieModel.getNumberOfStates() - 1;
        double d = HAModelViewTransform.transform(DeBroglieModel.getOrbitRadius(n));
        int n2 = DeBroglieBrightnessNode.calculateNumberOfPolygons(d);
        this.createReusablePolygons(n2);
        this.update();
    }

    private void createReusablePolygons(int n) {
        this._pathShapes = new GeneralPath[n];
        this._pathNodes = new PPath[n];
        for (int i = 0; i < n; ++i) {
            this._pathShapes[i] = new GeneralPath();
            this._pathNodes[i] = new PPath();
            this._pathNodes[i].setStroke(null);
        }
    }

    public void update() {
        int n = this.getAtom().getElectronState();
        if (n != this._previousState) {
            this._previousState = n;
            double d = HAModelViewTransform.transform(this.getAtom().getElectronOrbitRadius());
            int n2 = DeBroglieBrightnessNode.calculateNumberOfPolygons(d);
            this.updateRingGeometry(n2);
        }
        this.updateRingColors();
    }

    private static int calculateNumberOfPolygons(double d) {
        double d2 = Math.PI * (2.0 * d);
        int n = (int)(d2 / 3.0) + 1;
        return n;
    }

    private void updateRingGeometry(int n) {
        this._ringNode.removeAllChildren();
        this._polygons.clear();
        double d = HAModelViewTransform.transform(this.getAtom().getElectronOrbitRadius());
        if (n > this._pathNodes.length) {
            System.err.println("WARNING: DebroglieBrightnessNode.updateRingGeometry needed to allocate more objects to create ring geometry");
            this.createReusablePolygons(n);
        }
        for (int i = 0; i < n; ++i) {
            double d2 = Math.PI * 2 * ((double)i / (double)n);
            double d3 = d2 + Math.PI * 2 / (double)n + 0.001;
            double d4 = d - 2.5;
            double d5 = d + 2.5;
            double d6 = Math.cos(d2);
            double d7 = Math.sin(d2);
            double d8 = Math.cos(d3);
            double d9 = Math.sin(d3);
            double d10 = d4 * d6;
            double d11 = d4 * d7;
            double d12 = d5 * d6;
            double d13 = d5 * d7;
            double d14 = d5 * d8;
            double d15 = d5 * d9;
            double d16 = d4 * d8;
            double d17 = d4 * d9;
            GeneralPath generalPath = this._pathShapes[i];
            generalPath.reset();
            generalPath.moveTo((float)d10, (float)d11);
            generalPath.lineTo((float)d12, (float)d13);
            generalPath.lineTo((float)d14, (float)d15);
            generalPath.lineTo((float)d16, (float)d17);
            generalPath.closePath();
            PPath pPath = this._pathNodes[i];
            pPath.setPathTo(generalPath);
            pPath.setPaint(Color.RED);
            this._ringNode.addChild(pPath);
            this._polygons.add(pPath);
        }
    }

    private void updateRingColors() {
        int n = this._polygons.size();
        for (int i = 0; i < n; ++i) {
            double d = Math.PI * 2 * ((double)i / (double)n);
            double d2 = this.getAtom().getAmplitude(d);
            Color color = this.amplitudeToColor(d2);
            PPath pPath = (PPath)this._polygons.get(i);
            pPath.setPaint(color);
        }
    }

    protected Color amplitudeToColor(double d) {
        assert (d >= -1.0 && d <= 1.0);
        Color color = null;
        color = d > 0.0 ? ColorUtils.interpolateRBGA(ZERO_COLOR, PLUS_COLOR, d) : ColorUtils.interpolateRBGA(ZERO_COLOR, MINUS_COLOR, -d);
        return color;
    }
}

