/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view;

import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SpectrumImageFactory;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.control.CloseButtonNode;
import edu.colorado.phet.hydrogenatom.model.AbstractHydrogenAtom;
import edu.colorado.phet.hydrogenatom.model.Photon;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SpectrometerNode
extends PhetPNode
implements AbstractHydrogenAtom.AtomListener {
    private static final Color DISPLAY_BACKGROUND = Color.BLACK;
    private static final Color TITLE_COLOR = Color.WHITE;
    private static final Color TICK_COLOR = Color.WHITE;
    private static final Stroke TICK_STROKE = new BasicStroke(1.0f);
    private static final Font TICK_FONT = new PhetFont(1, 14);
    private static final Font UV_IR_FONT = new PhetFont(1, 18);
    private final Dimension _size;
    private final Font _font;
    private final double _minWavelength;
    private final double _maxWavelength;
    private boolean _isRunning;
    private final ArrayList<MeterRecord> _meterRecords;
    private PImage _panelNode;
    private PNode _displayAreaNode;
    private PNode _cellsNode;
    private PText _titleNode;
    private final CloseButtonNode _closeButton;
    private JButton _startStopButton;
    private JButton _resetButton;
    private JButton _snapshotButton;
    private PSwing _buttonPanelWrapper;
    private final double _minUVPosition;
    private final double _maxUVPosition;
    private final double _minVisiblePosition;
    private final double _maxVisiblePosition;
    private final double _minIRPosition;
    private final double _maxIRPosition;
    private int _maxCells;

    public SpectrometerNode(Dimension dimension, String string, Font font, double d, double d2) {
        double d3;
        if (d >= 380.0 || d2 <= 780.0) {
            throw new IllegalArgumentException("requries a spectrum the contains UV, IR and visible wavelengths");
        }
        this._size = new Dimension(dimension.width, dimension.height);
        this._font = font;
        this._minWavelength = d;
        this._maxWavelength = d2;
        this._isRunning = false;
        this._meterRecords = new ArrayList();
        this._panelNode = HAResources.getImageNode("spectrometerPanel.png");
        double d4 = (double)dimension.width / this._panelNode.getWidth();
        double d5 = (double)dimension.height / this._panelNode.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d4, d5);
        this._panelNode.setTransform(affineTransform);
        this._panelNode.setOffset(0.0, 0.0);
        d4 = Math.max(1.0, dimension.getWidth() - 20.0 - 20.0);
        d5 = d4 * 0.15;
        double d6 = d4 * 0.15;
        double d7 = d4 * 0.7;
        assert (d7 > 0.0);
        this._minUVPosition = 10.0;
        this._minVisiblePosition = this._maxUVPosition = this._minUVPosition + d5;
        this._minIRPosition = this._maxVisiblePosition = this._minVisiblePosition + d7;
        this._maxIRPosition = this._minIRPosition + d6;
        this._titleNode = new PText(string);
        this._titleNode.setFont(font);
        this._titleNode.setTextPaint(TITLE_COLOR);
        this._titleNode.setOffset(15.0, 7.0);
        this._closeButton = new CloseButtonNode();
        this._closeButton.setOffset(dimension.getWidth() - this._closeButton.getFullBounds().getWidth() - 18.0, -1.5);
        Object object = this._isRunning ? HAResources.getString("button.spectrometer.stop") : HAResources.getString("button.spectrometer.start");
        this._startStopButton = new JButton((String)object);
        this._startStopButton.setFont(font);
        this._startStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SpectrometerNode.this._isRunning) {
                    SpectrometerNode.this.stop();
                } else {
                    SpectrometerNode.this.start();
                }
            }
        });
        this._resetButton = new JButton(HAResources.getString("button.spectrometer.reset"));
        this._resetButton.setFont(font);
        this._resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrometerNode.this.reset();
            }
        });
        Object object2 = HAResources.getImage("camera.png");
        ImageIcon imageIcon = new ImageIcon((Image)object2);
        this._snapshotButton = new JButton(imageIcon);
        this._snapshotButton.setMargin(new Insets(0, 0, 0, 0));
        Serializable serializable = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._startStopButton, n, n2++);
        easyGridBagLayout.addComponent(this._resetButton, n, n2++);
        easyGridBagLayout.addComponent(this._snapshotButton, n, n2);
        this._buttonPanelWrapper = new PSwing((JComponent)serializable);
        this._buttonPanelWrapper.addInputEventListener(new CursorHandler());
        PBounds pBounds = this._buttonPanelWrapper.getFullBounds();
        this._buttonPanelWrapper.setOffset(dimension.getWidth() / 2.0 - pBounds.getWidth() / 2.0, dimension.getHeight() - pBounds.getHeight() - 5.0);
        ((JComponent)serializable).setOpaque(false);
        if (PhetUtilities.isMacintosh()) {
            this._startStopButton.setOpaque(false);
            this._resetButton.setOpaque(false);
        }
        this._snapshotButton.setOpaque(false);
        object = this.createTickLabel(0);
        object2 = new PPath();
        double d8 = dimension.getWidth() - 20.0;
        if (d8 < 1.0) {
            d8 = 1.0;
        }
        if ((d3 = dimension.getHeight() - 7.0 - this._titleNode.getFullBounds().getHeight() - 5.0 - 4.0 - 2.0 - ((PNode)object).getHeight() - 5.0 - this._buttonPanelWrapper.getFullBounds().getHeight() - 5.0) < 1.0) {
            d3 = 1.0;
        }
        Cloneable cloneable = new RoundRectangle2D.Double(0.0, 0.0, d8, d3, 10.0, 10.0);
        ((PPath)object2).setPathTo((Shape)((Object)cloneable));
        ((PNode)object2).setPaint(DISPLAY_BACKGROUND);
        ((PPath)object2).setStroke(null);
        ((PNode)object2).setOffset(0.0, 0.0);
        PNode pNode = new PNode();
        serializable = new PPath(new Rectangle2D.Double(0.0, 0.0, d5, 2.0));
        ((PNode)serializable).setPaint(HAConstants.UV_COLOR);
        ((PPath)serializable).setStroke(null);
        PNode pNode2 = new PPath(new Rectangle2D.Double(0.0, 0.0, d6, 2.0));
        pNode2.setPaint(HAConstants.IR_COLOR);
        ((PPath)pNode2).setStroke(null);
        Object object3 = new SpectrumImageFactory.LinearSpectrumImageFactory().createHorizontalSpectrum((int)d7, 2);
        cloneable = new PImage((Image)object3);
        pNode.addChild((PNode)serializable);
        pNode.addChild(pNode2);
        pNode.addChild((PNode)cloneable);
        ((PNode)serializable).setOffset(this._minUVPosition, 0.0);
        ((PNode)cloneable).setOffset(this._minVisiblePosition, 0.0);
        pNode2.setOffset(this._minIRPosition, 0.0);
        double d9 = 0.0;
        double d10 = ((PNode)object2).getHeight() - pNode.getHeight() - 4.0;
        pNode.setOffset(d9, d10);
        serializable = new PNode();
        ((PNode)serializable).setOffset(0.0, ((PNode)object2).getHeight());
        pNode2 = this.createMajorTickMark();
        pNode2.setOffset(this._minUVPosition, 0.0);
        object3 = this.createTickLabel((int)this._minWavelength);
        ((PNode)object3).setOffset(this._minUVPosition - ((PNode)object3).getWidth() / 2.0, pNode2.getHeight() + 2.0);
        ((PNode)serializable).addChild(pNode2);
        ((PNode)serializable).addChild((PNode)object3);
        cloneable = this.createMajorTickMark();
        ((PNode)cloneable).setOffset(this._maxIRPosition, 0.0);
        PNode pNode3 = this.createTickLabel((int)this._maxWavelength);
        pNode3.setOffset(this._maxIRPosition - pNode3.getWidth() / 2.0, ((PNode)cloneable).getHeight() + 2.0);
        ((PNode)serializable).addChild((PNode)cloneable);
        ((PNode)serializable).addChild(pNode3);
        int[] nArray = new int[]{380, 500, 600, 700, 780};
        for (int i = 0; i < nArray.length; ++i) {
            PNode pNode4 = this.createMajorTickMark();
            double d11 = ((double)nArray[i] - 380.0) / 400.0;
            double d12 = this._minVisiblePosition + d11 * (this._maxVisiblePosition - this._minVisiblePosition);
            pNode4.setOffset(d12, 0.0);
            PNode pNode5 = this.createTickLabel(nArray[i]);
            pNode5.setOffset(d12 - pNode5.getWidth() / 2.0, pNode4.getHeight() + 2.0);
            ((PNode)serializable).addChild(pNode4);
            ((PNode)serializable).addChild(pNode5);
        }
        int[] nArray2 = new int[]{400, 450, 550, 650, 750};
        for (int i = 0; i < nArray2.length; ++i) {
            PNode pNode6 = this.createMinorTickMark();
            double d13 = ((double)nArray2[i] - 380.0) / 400.0;
            double d14 = this._minVisiblePosition + d13 * (this._maxVisiblePosition - this._minVisiblePosition);
            pNode6.setOffset(d14, 0.0);
            ((PNode)serializable).addChild(pNode6);
        }
        PText pText = new PText("UV");
        pText.setTextPaint(TICK_COLOR);
        pText.setFont(UV_IR_FONT);
        pText.setOffset(this._minUVPosition + (this._maxUVPosition - this._minUVPosition) / 2.0 - pText.getWidth() / 2.0, 6.0);
        ((PNode)serializable).addChild(pText);
        PText pText2 = new PText("IR");
        pText2.setTextPaint(TICK_COLOR);
        pText2.setFont(UV_IR_FONT);
        pText2.setOffset(this._minIRPosition + (this._maxIRPosition - this._minIRPosition) / 2.0 - pText2.getWidth() / 2.0, 6.0);
        ((PNode)serializable).addChild(pText2);
        pNode2 = new PNode();
        pNode2.addChild((PNode)object2);
        pNode2.addChild(pNode);
        pNode2.addChild((PNode)serializable);
        object3 = new PImage(pNode2.toImage());
        ((PNode)object3).setOffset(0.0, 0.0);
        this._cellsNode = new PNode();
        this._cellsNode.setOffset(0.0, ((PNode)object2).getHeight() - pNode.getHeight() - 4.0 - 2.0);
        this._displayAreaNode = new PNode();
        double d15 = 10.0;
        double d16 = 7.0 + this._titleNode.getFullBounds().getHeight() + 5.0;
        this._displayAreaNode.setOffset(d15, d16);
        this._displayAreaNode.addChild((PNode)object3);
        this._displayAreaNode.addChild(this._cellsNode);
        this._maxCells = (int)((((PNode)object2).getHeight() - pNode.getHeight() - 4.0 - 2.0) / 5.0);
        this.addChild(this._panelNode);
        this.addChild(this._displayAreaNode);
        this.addChild(this._titleNode);
        this.addChild(this._closeButton);
        this.addChild(this._buttonPanelWrapper);
    }

    public SpectrometerSnapshotNode getSnapshot(String string) {
        return new SpectrometerSnapshotNode(this, string);
    }

    public void addCloseListener(ActionListener actionListener) {
        this._closeButton.addActionListener(actionListener);
    }

    public void addSnapshotListener(ActionListener actionListener) {
        this._snapshotButton.addActionListener(actionListener);
    }

    protected Dimension getSize() {
        return this._size;
    }

    protected Font getFont() {
        return this._font;
    }

    protected Image getDisplayAreaImage() {
        return this._displayAreaNode.toImage();
    }

    public void start() {
        this._isRunning = true;
        this._startStopButton.setText(HAResources.getString("button.spectrometer.stop"));
    }

    public void stop() {
        this._isRunning = false;
        this._startStopButton.setText(HAResources.getString("button.spectrometer.start"));
    }

    public void reset() {
        this._meterRecords.clear();
        this._cellsNode.removeAllChildren();
    }

    public void photonAbsorbed(Photon photon) {
    }

    public void photonEmitted(Photon photon) {
        if (this._isRunning && this.isVisible()) {
            double d = photon.getWavelength();
            MeterRecord meterRecord = this.getMeterRecord(d);
            if (meterRecord == null) {
                meterRecord = new MeterRecord(d);
                meterRecord.count = 1;
                this._meterRecords.add(meterRecord);
            } else {
                ++meterRecord.count;
            }
            this.addCell(meterRecord);
        }
    }

    private MeterRecord getMeterRecord(double d) {
        for (MeterRecord meterRecord : this._meterRecords) {
            if (meterRecord.wavelength != d) continue;
            return meterRecord;
        }
        return null;
    }

    private PNode createMajorTickMark() {
        return this.createTickMark(4.0);
    }

    private PNode createMinorTickMark() {
        return this.createTickMark(2.0);
    }

    private PNode createTickMark(double d) {
        PPath pPath = new PPath();
        Line2D.Double double_ = new Line2D.Double(0.0, 0.0, 0.0, d);
        pPath.setPathTo(double_);
        pPath.setStroke(TICK_STROKE);
        pPath.setStrokePaint(TICK_COLOR);
        return pPath;
    }

    private PNode createTickLabel(int n) {
        PText pText = new PText(String.valueOf(n));
        pText.setFont(TICK_FONT);
        pText.setTextPaint(TICK_COLOR);
        return pText;
    }

    private void addCell(MeterRecord meterRecord) {
        double d = meterRecord.wavelength;
        int n = meterRecord.count;
        if (n <= this._maxCells) {
            PNode pNode = this.createCell(d);
            this._cellsNode.addChild(pNode);
            double d2 = 0.0;
            double d3 = -((double)n * 5.0);
            if (d < 380.0) {
                double d4 = (d - this._minWavelength) / (380.0 - this._minWavelength);
                d2 = this._minUVPosition + d4 * (this._maxUVPosition - this._minUVPosition) - pNode.getWidth() / 2.0;
            } else if (d > 780.0) {
                double d5 = (this._maxWavelength - d) / (this._maxWavelength - 780.0);
                d2 = this._minIRPosition + d5 * (this._maxIRPosition - this._minIRPosition) - pNode.getWidth() / 2.0;
            } else {
                double d6 = (d - 380.0) / 400.0;
                d2 = this._minVisiblePosition + d6 * (this._maxVisiblePosition - this._minVisiblePosition) - pNode.getWidth() / 2.0;
            }
            pNode.setOffset(d2, d3);
        }
    }

    private PNode createCell(double d) {
        PPath pPath = new PPath(new Ellipse2D.Double(0.0, 0.0, 5.0, 5.0));
        Color color = VisibleColor.wavelengthToColor(d, HAConstants.UV_COLOR, HAConstants.IR_COLOR);
        pPath.setPaint(color);
        pPath.setStroke(null);
        return pPath;
    }

    private static class MeterRecord {
        public double wavelength;
        public int count;

        public MeterRecord(double d) {
            this.wavelength = d;
            this.count = 0;
        }
    }

    public static class SpectrometerSnapshotNode
    extends PhetPNode {
        private final CloseButtonNode _closeButton;

        protected SpectrometerSnapshotNode(SpectrometerNode spectrometerNode, String string) {
            PImage pImage = HAResources.getImageNode("spectrometerSnapshotPanel.png");
            Dimension dimension = spectrometerNode.getSize();
            double d = (double)dimension.width / pImage.getWidth();
            double d2 = (double)dimension.height / pImage.getHeight();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(d, d2);
            pImage.setTransform(affineTransform);
            pImage.setOffset(0.0, 0.0);
            PBounds pBounds = pImage.getFullBounds();
            PText pText = new PText(string);
            Font font = spectrometerNode.getFont();
            pText.setFont(font);
            pText.setTextPaint(TITLE_COLOR);
            pText.setOffset(pBounds.getX() + 15.0, pBounds.getY() + 7.0);
            Image image = spectrometerNode.getDisplayAreaImage();
            PImage pImage2 = new PImage(image);
            double d3 = 10.0;
            double d4 = 7.0 + pText.getFullBounds().getHeight() + 5.0;
            pImage2.setOffset(d3, d4);
            PNode pNode = new PNode();
            pNode.addChild(pImage);
            pNode.addChild(pImage2);
            pNode.addChild(pText);
            PImage pImage3 = new PImage(pNode.toImage());
            this._closeButton = new CloseButtonNode();
            this._closeButton.setOffset(pBounds.getMaxX() - this._closeButton.getFullBounds().getWidth() - 18.0, pBounds.getY() + -1.5);
            this.addChild(pImage3);
            this.addChild(this._closeButton);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseDragged(PInputEvent pInputEvent) {
                    double d = pInputEvent.getCanvasDelta().width;
                    double d2 = pInputEvent.getCanvasDelta().height;
                    SpectrometerSnapshotNode.this.translate(d, d2);
                }

                public void mousePressed(PInputEvent pInputEvent) {
                    SpectrometerSnapshotNode.this.moveToFront();
                }
            });
        }

        public void addCloseListener(ActionListener actionListener) {
            this._closeButton.addActionListener(actionListener);
        }
    }
}

