/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.util.PhotonImageFactory;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.view.particle.AlphaParticleNode;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.colorado.phet.hydrogenatom.view.particle.NeutronNode;
import edu.colorado.phet.hydrogenatom.view.particle.ProtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class LegendPanel
extends JPanel {
    private static final Color PANEL_COLOR = Color.BLACK;
    private static final Color LABEL_COLOR = Color.WHITE;

    public LegendPanel() {
        int n = HAResources.getInt("legend.font.size", 18);
        PhetFont phetFont = new PhetFont(1, n);
        JLabel jLabel = this.toJLabel(PhotonImageFactory.createPhotonImage(600.0, 30.0));
        JLabel jLabel2 = new JLabel(HAResources.getString("label.photon"));
        jLabel2.setFont(phetFont);
        jLabel2.setForeground(LABEL_COLOR);
        JLabel jLabel3 = this.toJLabel(PhotonImageFactory.createPhotonImage(379.0, 30.0));
        JLabel jLabel4 = new JLabel(HAResources.getString("label.uvPhoton"));
        jLabel4.setFont(phetFont);
        jLabel4.setForeground(LABEL_COLOR);
        JLabel jLabel5 = this.toJLabel(PhotonImageFactory.createPhotonImage(781.0, 30.0));
        JLabel jLabel6 = new JLabel(HAResources.getString("label.irPhoton"));
        jLabel6.setFont(phetFont);
        jLabel6.setForeground(LABEL_COLOR);
        JLabel jLabel7 = this.toJLabel(AlphaParticleNode.createImage());
        JLabel jLabel8 = new JLabel(HAResources.getString("label.alphaParticle"));
        jLabel8.setFont(phetFont);
        jLabel8.setForeground(LABEL_COLOR);
        JLabel jLabel9 = this.toJLabel(new NeutronNode());
        JLabel jLabel10 = new JLabel(HAResources.getString("label.neutron"));
        jLabel10.setFont(phetFont);
        jLabel10.setForeground(LABEL_COLOR);
        JLabel jLabel11 = this.toJLabel(new ProtonNode());
        JLabel jLabel12 = new JLabel(HAResources.getString("label.proton"));
        jLabel12.setFont(phetFont);
        jLabel12.setForeground(LABEL_COLOR);
        JLabel jLabel13 = this.toJLabel(new ElectronNode());
        JLabel jLabel14 = new JLabel(HAResources.getString("label.electron"));
        jLabel14.setFont(phetFont);
        jLabel14.setForeground(LABEL_COLOR);
        CompoundBorder compoundBorder = null;
        Serializable serializable = new EmptyBorder(new Insets(5, 5, 5, 5));
        LineBorder lineBorder = new LineBorder(LABEL_COLOR, 1);
        TitledBorder titledBorder = new TitledBorder(lineBorder, HAResources.getString("label.legend"));
        titledBorder.setTitleFont(phetFont);
        titledBorder.setTitleColor(LABEL_COLOR);
        compoundBorder = new CompoundBorder((Border)((Object)serializable), titledBorder);
        this.setBorder(compoundBorder);
        this.setBackground(PANEL_COLOR);
        serializable = new EasyGridBagLayout(this);
        ((EasyGridBagLayout)serializable).setInsets(new Insets(8, 8, 8, 8));
        this.setLayout((LayoutManager)((Object)serializable));
        int n2 = 0;
        int n3 = 0;
        ((EasyGridBagLayout)serializable).addComponent(jLabel13, n2, n3++, 1, 1, 10);
        ((EasyGridBagLayout)serializable).addComponent(jLabel14, n2++, n3++, 1, 1, 17);
        n3 = 0;
        ((EasyGridBagLayout)serializable).addComponent(jLabel11, n2, n3++, 1, 1, 10);
        ((EasyGridBagLayout)serializable).addComponent(jLabel12, n2++, n3++, 1, 1, 17);
        n3 = 0;
        ((EasyGridBagLayout)serializable).addComponent(jLabel9, n2, n3++, 1, 1, 10);
        ((EasyGridBagLayout)serializable).addComponent(jLabel10, n2++, n3++, 1, 1, 17);
        n3 = 0;
    }

    private JLabel toJLabel(Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        return new JLabel(imageIcon);
    }

    private JLabel toJLabel(PNode pNode) {
        ImageIcon imageIcon = new ImageIcon(pNode.toImage());
        return new JLabel(imageIcon);
    }

    public static class LegendDialog
    extends PaintImmediateDialog {
        public LegendDialog(Frame frame) {
            super(frame);
            this.createUI(frame);
        }

        private void createUI(Frame frame) {
            LegendPanel legendPanel = new LegendPanel();
            JPanel jPanel = this.createActionsPanel();
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)new JSeparator(), "North");
            jPanel2.add((Component)jPanel, "Center");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setBorder(new EmptyBorder(10, 10, 0, 10));
            jPanel3.add((Component)legendPanel, "Center");
            jPanel3.add((Component)jPanel2, "South");
            this.getContentPane().add(jPanel3);
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(frame);
        }

        private JPanel createActionsPanel() {
            JButton jButton = new JButton(HAResources.getString("button.close"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LegendDialog.this.dispose();
                }
            });
            JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
            jPanel.add(jButton);
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(jPanel);
            return jPanel2;
        }
    }

    public static class LegendNode
    extends PhetPNode {
        public LegendNode() {
            this.setPickable(false);
            this.setChildrenPickable(false);
            LegendPanel legendPanel = new LegendPanel();
            PSwing pSwing = new PSwing(legendPanel);
            this.addChild(pSwing);
        }
    }
}

