/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.common.phetcommon.math.ProbabilisticChooser;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.hydrogenatom.enums.DeBroglieView;
import edu.colorado.phet.hydrogenatom.hacks.MetastableHandler;
import edu.colorado.phet.hydrogenatom.model.AssociatedLegendrePolynomials;
import edu.colorado.phet.hydrogenatom.model.BohrModel;
import edu.colorado.phet.hydrogenatom.model.DeBroglieModel;
import edu.colorado.phet.hydrogenatom.model.Gun;
import edu.colorado.phet.hydrogenatom.util.RandomUtils;
import java.awt.geom.Point2D;
import java.util.Random;

public class SchrodingerModel
extends DeBroglieModel {
    private static final double[][] TRANSITION_STRENGTH = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {12.53, 0.0, 0.0, 0.0, 0.0}, {3.34, 0.87, 0.0, 0.0, 0.0}, {1.36, 0.24, 0.07, 0.0, 0.0}, {0.69, 0.11, 0.0, 0.04, 0.0}, {0.39, 0.06, 0.02, 0.0, 0.0}};
    private int _l;
    private int _m;
    private Random _lRandom;
    private Random _mRandom;
    private Point2D _spontaneousEmissionPoint;
    private MetastableHandler _metastableHandler;

    public SchrodingerModel(Point2D point2D, IClock iClock, Gun gun) {
        super(point2D);
        super.setView(DeBroglieView.BRIGHTNESS_MAGNITUDE);
        assert (SchrodingerModel.getGroundState() == 1);
        this._l = 0;
        this._m = 0;
        this._lRandom = new Random();
        this._mRandom = new Random();
        this._spontaneousEmissionPoint = new Point2D.Double();
        this._metastableHandler = new MetastableHandler(iClock, gun, this);
    }

    public void cleanup() {
        this._metastableHandler.cleanup();
    }

    public int getSecondaryElectronState() {
        return this._l;
    }

    public int getTertiaryElectronState() {
        return this._m;
    }

    public boolean stateEquals(int n, int n2, int n3) {
        return this.getElectronState() == n && n2 == this._l && n3 == this._m;
    }

    protected boolean absorptionIsCertain() {
        if (this.getElectronState() == 2 && this._l == 0) {
            return true;
        }
        return super.absorptionIsCertain();
    }

    protected boolean stimulatedEmissionIsAllowed(int n, int n2) {
        boolean bl = true;
        if (n2 == n) {
            bl = false;
        } else if (n2 == 1 && this._l == 0) {
            bl = false;
        } else if (n2 == 1 && this._l != 1) {
            bl = false;
        }
        return bl;
    }

    protected int chooseLowerElectronState() {
        int n = this.getElectronState();
        return this.getLowerPrimaryState(n);
    }

    protected void setElectronState(int n) {
        int n2 = this.getNewSecondaryState(n, this._l);
        int n3 = this.getNewTertiaryState(n2, this._m);
        boolean bl = SchrodingerModel.isaValidTransition(this.getElectronState(), this._l, this._m, n, n2, n3);
        if (bl) {
            this._l = n2;
            this._m = n3;
            super.setElectronState(n);
        } else {
            SchrodingerModel.warnBadTransition(this.getElectronState(), this._l, this._m, n, n2, n3);
            this._l = 0;
            this._m = 0;
            super.setElectronState(1);
        }
    }

    protected Point2D getSpontaneousEmissionPositionRef() {
        double d = BohrModel.getOrbitRadius(1);
        double d2 = RandomUtils.nextAngle();
        double d3 = d * Math.cos(d2) + this.getX();
        double d4 = d * Math.sin(d2) + this.getY();
        this._spontaneousEmissionPoint.setLocation(d3, d4);
        return this._spontaneousEmissionPoint;
    }

    public void setView(DeBroglieView deBroglieView) {
        throw new UnsupportedOperationException("SchrodingerModel.setView is not supported");
    }

    private int getLowerPrimaryState(int n) {
        int n2 = -1;
        if (n < 2) {
            return -1;
        }
        if (n == 2) {
            if (this._l == 0) {
                return -1;
            }
            n2 = 1;
        } else if (n > 2) {
            int n3 = n - 1;
            int n4 = Math.max(this._l, 1);
            if (this._l == 0) {
                n4 = 2;
            }
            ProbabilisticChooser.Entry[] entryArray = new ProbabilisticChooser.Entry[n3 - n4 + 1];
            double d = 0.0;
            for (int i = 0; i < entryArray.length; ++i) {
                int n5 = n4 + i;
                double d2 = TRANSITION_STRENGTH[n - 1][n5 - 1];
                entryArray[i] = new ProbabilisticChooser.Entry(new Integer(n5), d2);
                d += d2;
            }
            if (d == 0.0) {
                return -1;
            }
            ProbabilisticChooser probabilisticChooser = new ProbabilisticChooser(entryArray);
            Integer n6 = (Integer)probabilisticChooser.get();
            if (n6 == null) {
                return -1;
            }
            n2 = n6;
        }
        return n2;
    }

    private int getNewSecondaryState(int n, int n2) {
        int n3 = 0;
        n3 = n2 == 0 ? 1 : (n2 == n ? n2 - 1 : (n2 == n - 1 ? n2 - 1 : (this._lRandom.nextBoolean() ? n2 + 1 : n2 - 1)));
        return n3;
    }

    private int getNewTertiaryState(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        n6 = n == 0 ? 0 : (n2 > n ? n : (n2 < -n ? -n : (n2 == n ? ((n5 = this._mRandom.nextInt(2)) == 0 ? n2 : n2 - 1) : (n2 == -n ? ((n4 = this._mRandom.nextInt(2)) == 0 ? n2 : n2 + 1) : ((n3 = this._mRandom.nextInt(3)) == 0 ? n2 + 1 : (n3 == 1 ? n2 - 1 : n2))))));
        return n6;
    }

    private static boolean isaValidTransition(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = true;
        if (n == n4) {
            bl = false;
        } else if (n4 < 1 || n4 > SchrodingerModel.getNumberOfStates()) {
            bl = false;
        } else if (n5 < 0 || n5 > n4 - 1) {
            bl = false;
        } else if (Math.abs(n2 - n5) != 1) {
            bl = false;
        } else if (n6 < -n5 || n6 > n5) {
            bl = false;
        } else if (Math.abs(n3 - n6) > 1) {
            bl = false;
        }
        return bl;
    }

    public static double getProbabilityDensity(int n, int n2, int n3, double d, double d2, double d3) {
        if (n < 1) {
            throw new IllegalArgumentException("violated 1 <= n");
        }
        if (n2 < 0 || n2 >= n) {
            throw new IllegalArgumentException("violated 0 <= l <= n-1");
        }
        if (n3 < -n2 || n3 > n2) {
            throw new IllegalArgumentException("violated -l <= m <= +l");
        }
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            throw new IllegalArgumentException("undefined for (x,y,z)=(0,0,0)");
        }
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d5 = Math.abs(d3) / d4;
        double d6 = SchrodingerModel.getWaveFunction(n, n2, n3, d4, d5);
        return d6 * d6;
    }

    private static double getWaveFunction(int n, int n2, int n3, double d, double d2) {
        double d3 = SchrodingerModel.getGeneralizedLaguerrePolynomial(n, n2, d);
        double d4 = AssociatedLegendrePolynomials.solve(n2, Math.abs(n3), d2);
        return d3 * d4;
    }

    private static double getGeneralizedLaguerrePolynomial(int n, int n2, double d) {
        double d2 = BohrModel.getOrbitRadius(n) / (double)(n * n);
        double d3 = Math.pow(d, n2) * Math.exp(-d / ((double)n * d2));
        double d4 = 2.0 * Math.pow((double)n * d2, -1.5);
        int n3 = n - n2 - 1;
        double d5 = d4;
        double d6 = d4;
        for (int i = 1; i <= n3; ++i) {
            d5 = 2.0 / ((double)n * d2) * ((double)(i + n2 - n) / ((double)i * ((double)i + 2.0 * (double)n2 + 1.0))) * d5;
            d6 += d5 * Math.pow(d, i);
        }
        return d3 * d6;
    }

    public static void warnBadTransition(int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println("WARNING! SchrodingerModel: bad transition " + SchrodingerModel.stateToString(n, n2, n3) + " -> " + SchrodingerModel.stateToString(n4, n5, n6));
    }

    public static String stateToString(int n, int n2, int n3) {
        return "(" + n + "," + n2 + "," + n3 + ")";
    }

    public String getStateAsString() {
        return SchrodingerModel.stateToString(this.getElectronState(), this._l, this._m);
    }

    public void addMetastableListener(MetastableHandler.MetastableListener metastableListener) {
        this._metastableHandler.addMetastableListener(metastableListener);
    }

    public void fireOneAbsorbablePhoton() {
        this._metastableHandler.fireObviousAbsorbablePhoton();
    }

    public boolean isMonochromaticLightType() {
        return this._metastableHandler.isMonochromaticLightType();
    }
}

