/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.model.AbstractHydrogenAtom;
import edu.colorado.phet.hydrogenatom.model.AlphaParticle;
import edu.colorado.phet.hydrogenatom.model.PlumPuddingModel;
import java.text.DecimalFormat;

public class RutherfordScattering {
    public static boolean DEBUG_OUTPUT_ENABLED = false;
    private static final DecimalFormat F = new DecimalFormat("0.00");

    private RutherfordScattering() {
    }

    public static void moveParticle(AbstractHydrogenAtom abstractHydrogenAtom, AlphaParticle alphaParticle, double d) {
        assert (d > 0.0);
        double d2 = RutherfordScattering.getD(abstractHydrogenAtom, alphaParticle);
        double d3 = RutherfordScattering.getX0(abstractHydrogenAtom, alphaParticle);
        assert (d3 > 0.0);
        double d4 = alphaParticle.getInitialPosition().getY() - abstractHydrogenAtom.getY();
        double d5 = Math.sqrt(d3 * d3 + (d4 *= -1.0) * d4);
        double d6 = 0.5 * (d3 + Math.sqrt(-2.0 * d2 * d5 - 2.0 * d2 * d4 + d3 * d3));
        assert (d6 > 0.0);
        double d7 = alphaParticle.getX();
        double d8 = alphaParticle.getY();
        double d9 = alphaParticle.getSpeed();
        double d10 = alphaParticle.getInitialSpeed();
        d7 -= abstractHydrogenAtom.getX();
        d8 -= abstractHydrogenAtom.getY();
        int n = 1;
        if (d7 < 0.0) {
            d7 *= -1.0;
            n = -1;
        }
        assert (d7 >= 0.0);
        double d11 = Math.sqrt(d7 * d7 + (d8 *= -1.0) * d8);
        double d12 = Math.atan2(d7, -d8);
        double d13 = d6 * Math.cos(d12) - d2 / 2.0 * Math.sin(d12);
        double d14 = d12 + d6 * d6 * d9 * d / (d11 * Math.sqrt(Math.pow(d6, 4.0) + d11 * d11 * d13 * d13));
        double d15 = Math.abs(d6 * d6 / (d6 * Math.sin(d14) + d2 / 2.0 * (Math.cos(d14) - 1.0)));
        double d16 = d10 * Math.sqrt(1.0 - d2 / d15);
        double d17 = d15 * Math.sin(d14);
        double d18 = -d15 * Math.cos(d14);
        if (DEBUG_OUTPUT_ENABLED) {
            System.out.println("RutherfordScattering.moveParticle");
            System.out.println("  particle id=" + alphaParticle.getId());
            System.out.println("  atom type=" + abstractHydrogenAtom.getClass().getName());
            System.out.println("  constants:");
            System.out.println("    L=" + F.format(HAConstants.ANIMATION_BOX_SIZE.height));
            System.out.println("    D=" + F.format(d2));
            System.out.println("    dt=" + F.format(d));
            System.out.println("    (x0,y0)=(" + F.format(d3) + "," + F.format(d4) + ")");
            System.out.println("    v0=" + F.format(d10));
            System.out.println("    b=" + F.format(d6));
            System.out.println("  current state:");
            System.out.println("    (x,y)=(" + F.format(d7) + "," + F.format(d8) + ")");
            System.out.println("    (r,phi)=(" + F.format(d11) + "," + F.format(Math.toDegrees(d12)) + ")");
            System.out.println("    v=" + F.format(d9));
            System.out.println("  new state:");
            System.out.println("    (x,y)=(" + F.format(d17) + "," + F.format(d18) + ")");
            System.out.println("    (r,phi)=(" + F.format(d15) + "," + F.format(Math.toDegrees(d14)) + ")");
            System.out.println("    v=" + F.format(d16));
        }
        d17 *= (double)n;
        d18 *= -1.0;
        alphaParticle.setPosition(d17 += abstractHydrogenAtom.getX(), d18 += abstractHydrogenAtom.getY());
        alphaParticle.setSpeed(d16);
        alphaParticle.setOrientation(d14);
    }

    private static double getX0(AbstractHydrogenAtom abstractHydrogenAtom, AlphaParticle alphaParticle) {
        double d = Math.abs(alphaParticle.getInitialPosition().getX() - abstractHydrogenAtom.getX());
        if (d == 0.0) {
            d = 0.01;
        }
        return d;
    }

    private static double getD(AbstractHydrogenAtom abstractHydrogenAtom, AlphaParticle alphaParticle) {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = HAConstants.ANIMATION_BOX_SIZE.height;
        double d5 = d4 / 16.0;
        d3 = abstractHydrogenAtom instanceof PlumPuddingModel ? ((d2 = RutherfordScattering.getX0(abstractHydrogenAtom, alphaParticle)) <= (d = ((PlumPuddingModel)abstractHydrogenAtom).getRadius()) ? d5 * d2 * d2 / (d * d) : d5) : d5;
        return d3;
    }
}

