/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.hydrogenatom.model.AbstractHydrogenAtom;
import edu.colorado.phet.hydrogenatom.model.AlphaParticle;
import edu.colorado.phet.hydrogenatom.model.Gun;
import edu.colorado.phet.hydrogenatom.model.Model;
import edu.colorado.phet.hydrogenatom.model.MovingObject;
import edu.colorado.phet.hydrogenatom.model.Photon;
import edu.colorado.phet.hydrogenatom.model.Space;
import java.util.ArrayList;

public class HAModel
extends Model
implements AbstractHydrogenAtom.AtomListener,
Gun.GunListener {
    private Gun _gun;
    private Space _space;
    private AbstractHydrogenAtom _atom;
    private ArrayList<Photon> _photons;
    private ArrayList<AlphaParticle> _alphaParticles;

    public HAModel(IClock iClock, Gun gun, Space space) {
        super(iClock);
        this._gun = gun;
        this._gun.addGunFiredListener(this);
        this.addModelElement(this._gun);
        this._space = space;
        this.addModelElement(this._space);
        this._atom = null;
        this._photons = new ArrayList();
        this._alphaParticles = new ArrayList();
    }

    public Space getSpace() {
        return this._space;
    }

    public Gun getGun() {
        return this._gun;
    }

    public AbstractHydrogenAtom getAtom() {
        return this._atom;
    }

    public void setAtom(AbstractHydrogenAtom abstractHydrogenAtom) {
        if (this._atom != null) {
            this._atom.cleanup();
            this.removeModelElement(this._atom);
        }
        this._atom = abstractHydrogenAtom;
        this._atom.addAtomListener(this);
        this.addModelElement(abstractHydrogenAtom);
    }

    public void addPhoton(Photon photon) {
        this._photons.add(photon);
        this.addModelElement(photon);
    }

    public void removePhoton(Photon photon) {
        this._photons.remove(photon);
        this.removeModelElement(photon);
    }

    public void removeAllPhotons() {
        for (Photon photon : new ArrayList<Photon>(this._photons)) {
            this.removePhoton(photon);
        }
    }

    public void addAlphaParticle(AlphaParticle alphaParticle) {
        this._alphaParticles.add(alphaParticle);
        this.addModelElement(alphaParticle);
    }

    public void removeAlphaParticle(AlphaParticle alphaParticle) {
        this._photons.remove(alphaParticle);
        this.removeModelElement(alphaParticle);
    }

    public void removeAllAlphaParticles() {
        for (AlphaParticle alphaParticle : new ArrayList<AlphaParticle>(this._alphaParticles)) {
            this.removeAlphaParticle(alphaParticle);
        }
    }

    public void clockTicked(ClockEvent clockEvent) {
        double d = clockEvent.getSimulationTimeChange();
        this._gun.stepInTime(d);
        this._atom.stepInTime(d);
        this.moveParticles(d);
        this.cullParticles();
    }

    private void moveParticles(double d) {
        if (this._atom != null) {
            MovingObject movingObject;
            int n;
            Object[] objectArray;
            if (this._photons.size() > 0) {
                objectArray = this._photons.toArray();
                for (n = 0; n < objectArray.length; ++n) {
                    movingObject = (Photon)objectArray[n];
                    this._atom.movePhoton((Photon)movingObject, d);
                }
            }
            if (this._alphaParticles.size() > 0) {
                objectArray = this._alphaParticles.toArray();
                for (n = 0; n < objectArray.length; ++n) {
                    movingObject = (AlphaParticle)objectArray[n];
                    this._atom.moveAlphaParticle((AlphaParticle)movingObject, d);
                }
            }
        }
    }

    private void cullParticles() {
        for (Photon movingObject : new ArrayList<Photon>(this._photons)) {
            if (this._space.contains(movingObject)) continue;
            this.removePhoton(movingObject);
        }
        for (AlphaParticle alphaParticle : new ArrayList<AlphaParticle>(this._alphaParticles)) {
            if (this._space.contains(alphaParticle)) continue;
            this.removeAlphaParticle(alphaParticle);
        }
    }

    public void photonFired(Photon photon) {
        this.addPhoton(photon);
    }

    public void alphaParticleFired(AlphaParticle alphaParticle) {
        this.addAlphaParticle(alphaParticle);
    }

    public void photonAbsorbed(Photon photon) {
        this.removePhoton(photon);
    }

    public void photonEmitted(Photon photon) {
        this.addPhoton(photon);
    }
}

