/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.hydrogenatom.enums.DeBroglieView;
import edu.colorado.phet.hydrogenatom.model.BohrModel;
import edu.colorado.phet.hydrogenatom.model.Photon;
import java.awt.geom.Point2D;

public class DeBroglieModel
extends BohrModel {
    public static DeBroglieView DEFAULT_VIEW = DeBroglieView.BRIGHTNESS_MAGNITUDE;
    private DeBroglieView _view = DEFAULT_VIEW;
    private Point2D _electronPosition3D = new Point2D.Double();

    public DeBroglieModel(Point2D point2D) {
        super(point2D);
    }

    public void setView(DeBroglieView deBroglieView) {
        if (deBroglieView != this._view) {
            this._view = deBroglieView;
            this.notifyObservers("view");
        }
    }

    public DeBroglieView getView() {
        return this._view;
    }

    public double getAmplitude(double d, int n) {
        assert (n >= DeBroglieModel.getGroundState() && n <= DeBroglieModel.getGroundState() + DeBroglieModel.getNumberOfStates() - 1);
        double d2 = this.getElectronAngle();
        double d3 = Math.sin((double)n * d) * Math.sin(d2);
        assert (d3 >= -1.0 && d3 <= 1.0);
        return d3;
    }

    public double getAmplitude(double d) {
        return this.getAmplitude(d, this.getElectronState());
    }

    protected boolean collides(Photon photon) {
        if (this._view == DeBroglieView.HEIGHT_3D) {
            return this.collides3D(photon);
        }
        return this.collides2D(photon);
    }

    private boolean collides3D(Photon photon) {
        double d;
        double d2;
        double d3 = photon.getX() - this.getX();
        double d4 = photon.getY() - this.getY();
        double d5 = Math.atan(d4 / d3);
        double d6 = this.getElectronOrbitRadius();
        double d7 = d6 * Math.cos(d5);
        double d8 = Point2D.distance(d3, d4, d7, d2 = 0.35 * d6 * Math.sin(d5));
        boolean bl = d8 <= (d = COLLISION_CLOSENESS + 2.5);
        return bl;
    }

    private boolean collides2D(Photon photon) {
        double d = photon.getX() - this.getX();
        double d2 = photon.getY() - this.getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = this.getElectronOrbitRadius();
        double d5 = COLLISION_CLOSENESS + 2.5;
        boolean bl = Math.abs(d3 - d4) <= d5;
        return bl;
    }

    protected double calculateNewElectronAngle(double d) {
        double d2 = d * this.getElectronAngleDelta();
        return this.getElectronAngle() - d2;
    }
}

