/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.hydrogenatom.model.AbstractHydrogenAtom;
import edu.colorado.phet.hydrogenatom.model.AlphaParticle;
import edu.colorado.phet.hydrogenatom.model.Photon;
import edu.colorado.phet.hydrogenatom.model.RutherfordScattering;
import edu.colorado.phet.hydrogenatom.util.RandomUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

public class BohrModel
extends AbstractHydrogenAtom {
    public static boolean DEBUG_ABSORPTION_ENABLED = true;
    public static boolean DEBUG_SPONTANEOUS_EMISSION_ENABLED = true;
    public static boolean DEBUG_STIMULATED_EMISSION_ENABLED = true;
    private static boolean DEBUG_OUTPUT_ENABLED = false;
    public static int MIN_TIME_IN_STATE = 50;
    private static final double[] ORBIT_RADII = new double[]{15.0, 44.0, 81.0, 124.0, 174.0, 233.0};
    private static final double ELECTRON_ANGLE_DELTA = Math.toRadians(10.0);
    private int _electronState = 1;
    private double _timeInState = 0.0;
    private double _electronAngle = RandomUtils.nextAngle();
    private Point2D _electronOffset = new Point2D.Double();
    private Point2D _electronPosition = new Point2D.Double();
    private Random _randomAbsorption = new Random();
    private Random _randomSpontaneousEmission = new Random();
    private Random _randomStimulatedEmission = new Random();
    private Random _randomState = new Random();

    public BohrModel(Point2D point2D) {
        super(point2D, 0.0);
        this.updateElectronOffset();
    }

    public void movePhoton(Photon photon, double d) {
        boolean bl = this.attemptAbsorption(photon);
        if (!bl) {
            this.attemptStimulatedEmission(photon);
            super.movePhoton(photon, d);
        }
    }

    public void moveAlphaParticle(AlphaParticle alphaParticle, double d) {
        RutherfordScattering.moveParticle(this, alphaParticle, d);
    }

    public static int getNumberOfStates() {
        return ORBIT_RADII.length;
    }

    public double[] getTransitionWavelengths(int n) {
        double[] dArray = null;
        int n2 = BohrModel.getGroundState() + BohrModel.getNumberOfStates() - 1;
        if (n < n2) {
            dArray = new double[n2 - n];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = BohrModel.getWavelengthAbsorbed(n, n + i + 1);
            }
        }
        return dArray;
    }

    public void stepInTime(double d) {
        this._timeInState += d;
        this._electronAngle = this.calculateNewElectronAngle(d);
        this.updateElectronOffset();
        this.attemptSpontaneousEmission();
    }

    public int getElectronState() {
        return this._electronState;
    }

    protected void setElectronState(int n) {
        assert (n >= 1 && n <= 1 + BohrModel.getNumberOfStates() - 1);
        if (n != this._electronState) {
            this._electronState = n;
            this._timeInState = 0.0;
            this.notifyObservers("electronState");
        }
    }

    public Point2D getElectronOffsetRef() {
        return this._electronOffset;
    }

    private void updateElectronOffset() {
        double d = BohrModel.getOrbitRadius(this._electronState);
        double d2 = d * Math.sin(this._electronAngle);
        double d3 = d * Math.cos(this._electronAngle);
        this._electronOffset.setLocation(d2, d3);
        this._electronPosition.setLocation(this.getX() + d2, this.getY() + d3);
        this.notifyObservers("electronOffset");
    }

    public double getElectronAngle() {
        return this._electronAngle;
    }

    protected double getElectronAngleDelta() {
        return ELECTRON_ANGLE_DELTA;
    }

    protected double calculateNewElectronAngle(double d) {
        double d2 = d * (ELECTRON_ANGLE_DELTA / (double)(this._electronState * this._electronState));
        return this._electronAngle - d2;
    }

    public static double getOrbitRadius(int n) {
        return ORBIT_RADII[n - 1];
    }

    public double getElectronOrbitRadius() {
        return BohrModel.getOrbitRadius(this._electronState);
    }

    public static double getWavelengthAbsorbed(int n, int n2) {
        assert (n < n2);
        assert (n > 0);
        assert (n2 <= 1 + BohrModel.getNumberOfStates() - 1);
        return 1240.0 / (13.6 * (1.0 / (double)(n * n) - 1.0 / (double)(n2 * n2)));
    }

    public static double getWavelengthEmitted(int n, int n2) {
        return BohrModel.getWavelengthAbsorbed(n2, n);
    }

    public static double getTransitionWavelength(int n, int n2) {
        if (n == n2) {
            throw new IllegalArgumentException("nOld == nNew");
        }
        if (n2 < n) {
            return BohrModel.getWavelengthEmitted(n, n2);
        }
        return BohrModel.getWavelengthAbsorbed(n, n2);
    }

    private boolean closeEnough(double d, double d2) {
        return Math.abs(d - d2) < 0.5;
    }

    public static double[] getTransitionWavelengths(double d, double d2) {
        int n;
        int n2;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n3 = BohrModel.getNumberOfStates();
        for (int i = n2 = BohrModel.getGroundState(); i < n2 + n3 - 1; ++i) {
            for (n = i + 1; n < n2 + n3; ++n) {
                double d3 = BohrModel.getWavelengthAbsorbed(i, n);
                if (!(d3 >= d) || !(d3 <= d2)) continue;
                arrayList.add(new Double(d3));
            }
        }
        double[] dArray = new double[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            dArray[n] = (Double)arrayList.get(n);
        }
        return dArray;
    }

    protected boolean collides(Photon photon) {
        Point2D point2D = photon.getPositionRef();
        return BohrModel.pointsCollide(this._electronPosition, point2D, COLLISION_CLOSENESS);
    }

    private boolean attemptAbsorption(Photon photon) {
        boolean bl;
        boolean bl2 = false;
        if (!DEBUG_ABSORPTION_ENABLED) {
            return false;
        }
        if (this._timeInState >= (double)MIN_TIME_IN_STATE && !photon.isEmitted() && (bl = this.collides(photon))) {
            boolean bl3 = false;
            int n = 0;
            int n2 = 1 + BohrModel.getNumberOfStates() - 1;
            double d = photon.getWavelength();
            for (int i = this._electronState + 1; i <= n2 && !bl3; ++i) {
                double d2 = BohrModel.getWavelengthAbsorbed(this._electronState, i);
                if (!this.closeEnough(d, d2)) continue;
                bl3 = true;
                n = i;
            }
            if (!this.absorptionIsAllowed(this._electronState, n)) {
                return false;
            }
            if (bl3 && this.absorptionIsCertain()) {
                bl2 = true;
                this.firePhotonAbsorbed(photon);
                if (DEBUG_OUTPUT_ENABLED) {
                    System.out.println("BohrModel: absorbed photon, wavelength=" + d);
                }
                this.setElectronState(n);
            }
        }
        return bl2;
    }

    protected boolean absorptionIsCertain() {
        return this._randomAbsorption.nextDouble() < 1.0;
    }

    private boolean absorptionIsAllowed(int n, int n2) {
        return true;
    }

    private boolean attemptStimulatedEmission(Photon photon) {
        boolean bl;
        boolean bl2 = false;
        if (!DEBUG_STIMULATED_EMISSION_ENABLED) {
            return false;
        }
        if (this._electronState > 1 && this._timeInState >= (double)MIN_TIME_IN_STATE && !photon.isEmitted() && (bl = this.collides(photon))) {
            boolean bl3 = false;
            double d = photon.getWavelength();
            int n = 0;
            for (int i = 1; i < this._electronState && !bl3; ++i) {
                double d2 = BohrModel.getWavelengthAbsorbed(i, this._electronState);
                if (!this.closeEnough(d, d2)) continue;
                bl3 = true;
                n = i;
            }
            if (!this.stimulatedEmissionIsAllowed(this._electronState, n)) {
                return false;
            }
            if (bl3 && this.stimulatedEmissionIsCertain()) {
                assert (photon.getOrientation() == Math.toRadians(-90.0));
                double d3 = photon.getWavelength();
                double d4 = photon.getX() + 10.0;
                double d5 = photon.getY();
                Point2D.Double double_ = new Point2D.Double(d4, d5);
                double d6 = photon.getOrientation();
                double d7 = 5.0;
                bl2 = true;
                this.firePhotonEmitted(new Photon(d3, double_, d6, d7, true));
                if (DEBUG_OUTPUT_ENABLED) {
                    System.out.println("BohrModel: stimulated emission of photon, wavelength=" + d3);
                }
                this.setElectronState(n);
            }
        }
        return bl2;
    }

    private boolean stimulatedEmissionIsCertain() {
        return this._randomStimulatedEmission.nextDouble() < 1.0;
    }

    protected boolean stimulatedEmissionIsAllowed(int n, int n2) {
        return n != n2 && n2 >= 1;
    }

    private boolean attemptSpontaneousEmission() {
        boolean bl = false;
        if (!DEBUG_SPONTANEOUS_EMISSION_ENABLED) {
            return false;
        }
        if (this._electronState > 1 && this._timeInState >= (double)MIN_TIME_IN_STATE && this.spontaneousEmissionIsCertain()) {
            int n = this.chooseLowerElectronState();
            if (n == -1) {
                return false;
            }
            Point2D point2D = this.getSpontaneousEmissionPositionRef();
            double d = RandomUtils.nextAngle();
            double d2 = 5.0;
            double d3 = BohrModel.getWavelengthEmitted(this._electronState, n);
            bl = true;
            this.firePhotonEmitted(new Photon(d3, point2D, d, d2, true));
            if (DEBUG_OUTPUT_ENABLED) {
                System.out.println("BohrModel: spontaneous emission of photon, wavelength=" + d3);
            }
            this.setElectronState(n);
        }
        return bl;
    }

    private boolean spontaneousEmissionIsCertain() {
        return this._randomSpontaneousEmission.nextDouble() < 0.5;
    }

    protected int chooseLowerElectronState() {
        int n = 1;
        if (this._electronState > 2) {
            n = 1 + this._randomState.nextInt(this._electronState - 1);
        }
        return n;
    }

    protected Point2D getSpontaneousEmissionPositionRef() {
        return this._electronPosition;
    }
}

