/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.hacks;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.hydrogenatom.model.Gun;
import edu.colorado.phet.hydrogenatom.model.SchrodingerModel;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import java.util.logging.Logger;

public class MetastableHandler
extends ClockAdapter
implements Observer {
    private static final Logger LOGGER = LoggingUtils.getLogger(MetastableHandler.class.getCanonicalName());
    public static double MAX_STUCK_TIME = 100.0;
    private final IClock _clock;
    private final Gun _gun;
    private final SchrodingerModel _atom;
    private boolean _stuck;
    private double _stuckTime;
    private final Random _nRandom;
    private final ArrayList<MetastableListener> _listeners;

    public MetastableHandler(IClock iClock, Gun gun, SchrodingerModel schrodingerModel) {
        this._clock = iClock;
        this._gun = gun;
        this._atom = schrodingerModel;
        this._stuck = false;
        this._stuckTime = 0.0;
        this._nRandom = new Random();
        this._clock.addClockListener(this);
        this._gun.addObserver(this);
        this._atom.addObserver(this);
        this._listeners = new ArrayList();
    }

    public void cleanup() {
        this._clock.removeClockListener(this);
        this._gun.deleteObserver(this);
        this._atom.deleteObserver(this);
    }

    public boolean isMonochromaticLightType() {
        return this._gun.isMonochromaticLightType();
    }

    public void clockTicked(ClockEvent clockEvent) {
        if (this._stuck && this._gun.isEnabled() && this._gun.isPhotonsMode() && this._gun.isWhiteLightType()) {
            this._stuckTime += clockEvent.getSimulationTimeChange();
            if (this._stuckTime >= MAX_STUCK_TIME) {
                LOGGER.info("atom has been stuck for " + this._stuckTime + " time units");
                this.fireRandomAbsorbablePhoton();
                this._stuckTime = 0.0;
            }
        }
    }

    private void fireRandomAbsorbablePhoton() {
        this.fireAbsorbablePhoton(3 + this._nRandom.nextInt(SchrodingerModel.getNumberOfStates() - 2));
    }

    public void fireObviousAbsorbablePhoton() {
        this.fireAbsorbablePhoton(3);
    }

    private void fireAbsorbablePhoton(int n) {
        assert (n > this._atom.getElectronState());
        if (this._gun.getPositionRef().getX() != this._atom.getPositionRef().getX()) {
            LOGGER.warning("photon will not hit atom, centers of gun and atom are not vertically aligned!");
        }
        double d = SchrodingerModel.getWavelengthAbsorbed(2, n);
        LOGGER.info("firing an absorbable photon, n=" + n + " wavelength=" + d);
        this._gun.fireOnePhotonFromCenter(d);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._atom && object == "electronState") {
            if (!this._stuck && this._atom.stateEquals(2, 0, 0)) {
                this._stuck = true;
                this._stuckTime = 0.0;
                LOGGER.info("atom is stuck in metastable state " + this._atom.getStateAsString());
                this.fireEnteredMetastableState();
            } else if (this._stuck && !this._atom.stateEquals(2, 0, 0)) {
                this._stuck = false;
                this._stuckTime = 0.0;
                LOGGER.info("atom is unstuck, transitioned to state " + this._atom.getStateAsString());
                this.fireExitedMetastableState();
            }
        }
    }

    public void addMetastableListener(MetastableListener metastableListener) {
        this._listeners.add(metastableListener);
    }

    private void fireEnteredMetastableState() {
        for (MetastableListener metastableListener : new ArrayList<MetastableListener>(this._listeners)) {
            metastableListener.enteredMetastableState();
        }
    }

    private void fireExitedMetastableState() {
        for (MetastableListener metastableListener : new ArrayList<MetastableListener>(this._listeners)) {
            metastableListener.exitedMetastableState();
        }
    }

    public static interface MetastableListener {
        public void enteredMetastableState();

        public void exitedMetastableState();
    }
}

