/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.energydiagrams;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.hydrogenatom.energydiagrams.AbstractEnergyDiagram;
import edu.colorado.phet.hydrogenatom.energydiagrams.EnergySquiggle;
import edu.colorado.phet.hydrogenatom.model.BohrModel;
import edu.colorado.phet.hydrogenatom.model.SchrodingerModel;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;

public class SchrodingerEnergyDiagram
extends AbstractEnergyDiagram
implements Observer {
    private IClock _clock;
    private ClockListener _clockListener;
    private SchrodingerModel _atom;
    private int _nPrevious;
    private int _lPrevious;
    private EnergySquiggle _squiggle;
    private double _squiggleLifetime;
    private PText _mNode;
    private double _lLabelWidth;
    private double _lLabelHeight;

    public SchrodingerEnergyDiagram(IClock iClock) {
        super(SchrodingerModel.getNumberOfStates());
        assert (SchrodingerModel.getGroundState() == 1);
        assert (SchrodingerModel.getNumberOfStates() == 6);
        Rectangle2D rectangle2D = this.getDrawingArea();
        this._mNode = new PText("m=-1");
        this._mNode.setFont(LABEL_FONT);
        this._mNode.setTextPaint(LABEL_COLOR);
        this._mNode.setOffset(rectangle2D.getX() + rectangle2D.getWidth() - this._mNode.getWidth() - 2.0, 2.0);
        this.getStateLayer().addChild(this._mNode);
        PText pText = new PText("l=");
        pText.setFont(LABEL_FONT);
        pText.setTextPaint(LABEL_COLOR);
        pText.setOffset(rectangle2D.getX() + 10.0, rectangle2D.getY() + 10.0);
        this.getStateLayer().addChild(pText);
        this._lLabelWidth = pText.getWidth();
        this._lLabelHeight = pText.getHeight();
        PNode pNode = SchrodingerEnergyDiagram.createLValuesNode();
        pNode.setOffset(rectangle2D.getX() + 10.0 + this._lLabelWidth + 2.0, rectangle2D.getY() + 10.0);
        this.getStateLayer().addChild(pNode);
        for (int i = 1; i <= SchrodingerModel.getNumberOfStates(); ++i) {
            PNode pNode2 = SchrodingerEnergyDiagram.createNNode(i);
            double d = this.getXOffset(0);
            double d2 = this.getYOffset(i);
            pNode2.setOffset(d, d2);
            this.getStateLayer().addChild(pNode2);
        }
        this._clockListener = new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                SchrodingerEnergyDiagram.this.checkSquiggleLifetime(clockEvent.getWallTimeChange());
            }
        };
        this._clock = iClock;
        this._clock.addClockListener(this._clockListener);
    }

    public void setAtom(SchrodingerModel schrodingerModel) {
        this.removeSquiggle();
        if (this._atom != null) {
            this._atom.deleteObserver(this);
            this._atom = null;
        }
        ElectronNode electronNode = this.getElectronNode();
        electronNode.setVisible(schrodingerModel != null);
        if (schrodingerModel != null) {
            this._atom = schrodingerModel;
            this._atom.addObserver(this);
            this.updateElectronPosition();
            this.updateM();
            this._nPrevious = schrodingerModel.getElectronState();
            this._lPrevious = schrodingerModel.getSecondaryElectronState();
        }
    }

    public void clearAtom() {
        this.setAtom(null);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof BohrModel && object == "electronState") {
            this.updateElectronPosition();
            this.updateM();
            this.updateSquiggle();
        }
    }

    private void updateSquiggle() {
        this.removeSquiggle();
        if (!this.isVisible()) {
            return;
        }
        int n = this._atom.getElectronState();
        if (n != this._nPrevious) {
            double d = BohrModel.getTransitionWavelength(this._nPrevious, n);
            int n2 = this._atom.getSecondaryElectronState();
            double d2 = this.getXOffset(this._lPrevious) + 5.0;
            double d3 = this.getYOffset(this._nPrevious);
            double d4 = this.getXOffset(n2) + 5.0;
            double d5 = this.getYOffset(n);
            this._squiggle = new EnergySquiggle(d2, d3, d4, d5, d);
            this.getSquiggleLayer().addChild(this._squiggle);
            this._nPrevious = n;
            this._lPrevious = n2;
        }
    }

    private void removeSquiggle() {
        if (this._squiggle != null) {
            this.getSquiggleLayer().removeChild(this._squiggle);
            this._squiggleLifetime = 0.0;
            this._squiggle = null;
        }
    }

    private void checkSquiggleLifetime(double d) {
        if (this._squiggle != null) {
            this._squiggleLifetime += d;
            if (this._squiggleLifetime > SQUIGGLE_LIFETIME) {
                this.removeSquiggle();
            }
        }
    }

    private void updateElectronPosition() {
        ElectronNode electronNode = this.getElectronNode();
        int n = this._atom.getElectronState();
        int n2 = this._atom.getSecondaryElectronState();
        double d = this.getXOffset(n2) + 5.0;
        double d2 = this.getYOffset(n) - electronNode.getFullBounds().getHeight() / 2.0;
        electronNode.setOffset(d, d2);
    }

    private void updateM() {
        int n = this._atom.getTertiaryElectronState();
        this._mNode.setText("m=" + String.valueOf(n));
    }

    protected double getXOffset(int n) {
        return this.getDrawingArea().getX() + 10.0 + this._lLabelWidth + 2.0 + (double)n * 10.0 + (double)n * 10.0;
    }

    protected double getYOffset(int n) {
        double d = this.getEnergy(1);
        double d2 = this.getEnergy(BohrModel.getNumberOfStates());
        double d3 = d2 - d;
        Rectangle2D rectangle2D = this.getDrawingArea();
        double d4 = this.getElectronNode().getFullBounds().getHeight();
        double d5 = rectangle2D.getHeight() - 20.0 - this._lLabelHeight - d4;
        double d6 = rectangle2D.getY() + 10.0 + this._lLabelHeight + d4 + d5 * (d2 - this.getEnergy(n)) / d3;
        return d6;
    }

    private static PNode createLValuesNode() {
        int n = SchrodingerModel.getNumberOfStates();
        PComposite pComposite = new PComposite();
        for (int i = 0; i < n; ++i) {
            PText pText = new PText(String.valueOf(i));
            pText.setFont(LABEL_FONT);
            pText.setTextPaint(LABEL_COLOR);
            pText.setOffset((double)i * 10.0 + (double)i * 10.0 + 5.0 - pText.getWidth() / 2.0, 0.0);
            pComposite.addChild(pText);
        }
        return pComposite;
    }

    private static PNode createNNode(int n) {
        PNode pNode;
        int n2 = SchrodingerModel.getNumberOfStates();
        PComposite pComposite = new PComposite();
        for (int i = 0; i < n; ++i) {
            pNode = SchrodingerEnergyDiagram.createStateLineNode();
            pNode.setOffset((double)i * 20.0, 0.0);
            pComposite.addChild(pNode);
        }
        PNode pNode2 = SchrodingerEnergyDiagram.createStateLabelNode(n);
        pNode = new PComposite();
        pNode.addChild(pComposite);
        pNode.addChild(pNode2);
        pComposite.setOffset(0.0, 0.0);
        double d = (double)n2 * 10.0 + (double)(n2 - 1) * 10.0 + 10.0;
        double d2 = -(pComposite.getHeight() / 2.0 + pNode2.getHeight() / 2.0);
        if (n == 6) {
            pNode2.setOffset(d, d2 - 3.5);
        } else {
            pNode2.setOffset(d, d2);
        }
        return pNode;
    }
}

