/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.energydiagrams;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class EnergySquiggle
extends PComposite {
    protected static final Stroke SQUIGGLE_STROKE = new BasicStroke(1.0f);
    private static final Dimension ARROW_HEAD_SIZE = new Dimension(20, 10);

    public EnergySquiggle(double d, double d2, double d3, double d4, double d5) {
        boolean bl;
        double d6 = Point2D.distance(d, d2, d3, d4);
        Color color = VisibleColor.wavelengthToColor(d5, HAConstants.UV_COLOR, HAConstants.IR_COLOR);
        boolean bl2 = bl = d6 > ARROW_HEAD_SIZE.getHeight() + 5.0;
        if (bl) {
            PPath pPath = new PPath();
            pPath.setPaint(color);
            pPath.setStroke(null);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)d6, 0.0f);
            generalPath.lineTo((float)(d6 - (double)EnergySquiggle.ARROW_HEAD_SIZE.height), EnergySquiggle.ARROW_HEAD_SIZE.width / 2);
            generalPath.lineTo((float)(d6 - (double)EnergySquiggle.ARROW_HEAD_SIZE.height), -EnergySquiggle.ARROW_HEAD_SIZE.width / 2);
            generalPath.closePath();
            pPath.setPathTo(generalPath);
            this.addChild(pPath);
        }
        double d7 = EnergySquiggle.wavelengthToPeriod(d5);
        PPath pPath = new PPath();
        pPath.setStroke(SQUIGGLE_STROKE);
        pPath.setStrokePaint(color);
        this.addChild(pPath);
        if (d6 >= 5.0) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            double d8 = bl ? d6 - ARROW_HEAD_SIZE.getHeight() : d6;
            int n = 0;
            while ((double)n < d8) {
                double d9 = (double)n % d7 * (Math.PI * 2 / d7);
                double d10 = 6.0 * Math.sin(d9);
                generalPath.lineTo(n, (float)d10);
                ++n;
            }
            pPath.setPathTo(generalPath);
        } else {
            pPath.setPathTo(new Line2D.Double(d, d2, d3, d4));
        }
        double d11 = Math.atan2(d4 - d2, d3 - d);
        AffineTransform affineTransform = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform.setToIdentity();
        affineTransform.translate(d, d2);
        affineTransform.rotate(d11);
        this.setTransform(affineTransform);
    }

    private static double wavelengthToPeriod(double d) {
        double d2 = 0.0;
        if (ColorUtils.isUV(d)) {
            d2 = 8.0;
        } else if (ColorUtils.isIR(d)) {
            d2 = 22.0;
        } else {
            double d3 = 400.0;
            double d4 = 10.0;
            double d5 = (d - 380.0) / d3;
            d2 = 10.0 + d5 * d4;
        }
        return d2;
    }
}

