/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.energydiagrams;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.control.CloseButtonNode;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PClip;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.Observer;

public abstract class AbstractEnergyDiagram
extends PhetPNode
implements Observer {
    public static double SQUIGGLE_LIFETIME = 1500.0;
    protected static final Stroke LINE_STROKE = new BasicStroke(2.0f);
    protected static final Color LINE_COLOR = Color.BLACK;
    protected static final Font LABEL_FONT = new PhetFont(1, 14);
    protected static final Color LABEL_COLOR = Color.BLACK;
    private static final Dimension WINDOW_SIZE = new Dimension(250, 505);
    private static final Color BACKGROUND_COLOR = new Color(240, 240, 240);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_STROKE_COLOR = Color.BLACK;
    private static final Color AXIS_COLOR = Color.BLACK;
    private static final Color AXIS_LABEL_COLOR = Color.BLACK;
    private static final Dimension AXIS_ARROW_SIZE = new Dimension(13, 13);
    private static final Color TITLE_BAR_COLOR = Color.GRAY;
    private static final Color TITLE_COLOR = Color.WHITE;
    private double[] _energies;
    private ElectronNode _electronNode;
    private PLayer _stateLayer;
    private PLayer _squiggleLayer;
    private CloseButtonNode _closeButton;
    private Rectangle2D _drawingArea;

    public AbstractEnergyDiagram(int n) {
        this.setPickable(false);
        int n2 = HAResources.getInt("energyDiagram.font.size", 16);
        PhetFont phetFont = new PhetFont(1, n2);
        int n3 = HAResources.getInt("energyDiagram.title.font.size", 16);
        PhetFont phetFont2 = new PhetFont(1, n3);
        PText pText = new PText(HAResources.getString("title.energyDiagram"));
        this._closeButton = new CloseButtonNode();
        PPath pPath = new PPath();
        pPath.addChild(pText);
        pPath.addChild(this._closeButton);
        double d = Math.max(pText.getHeight(), this._closeButton.getFullBounds().getHeight()) + 6.0;
        pPath.setPathTo(new Rectangle2D.Double(0.0, 0.0, AbstractEnergyDiagram.WINDOW_SIZE.width, AbstractEnergyDiagram.WINDOW_SIZE.height));
        pPath.setPaint(TITLE_BAR_COLOR);
        pPath.setStroke(null);
        pText.setOffset(6.0, 3.0);
        pText.setFont(phetFont2);
        pText.setTextPaint(TITLE_COLOR);
        this._closeButton.setOffset((double)AbstractEnergyDiagram.WINDOW_SIZE.width - this._closeButton.getFullBounds().getWidth() - 6.0, 3.0);
        this.addChild(pPath);
        double d2 = WINDOW_SIZE.getWidth() - 6.0;
        double d3 = WINDOW_SIZE.getHeight() - d - 3.0;
        PClip pClip = new PClip();
        pClip.setChildrenPickable(false);
        pClip.setPathTo(new Rectangle2D.Double(0.0, 0.0, d2, d3));
        pClip.setPaint(BACKGROUND_COLOR);
        pClip.setStroke(BACKGROUND_STROKE);
        pClip.setStrokePaint(BACKGROUND_STROKE_COLOR);
        pClip.setOffset(3.0, d);
        this.addChild(pClip);
        PNode pNode = AbstractEnergyDiagram.createAxisNode(d3 - 20.0, phetFont);
        this._stateLayer = new PLayer();
        this._squiggleLayer = new PLayer();
        this._electronNode = new ElectronNode();
        this._electronNode.setVisible(false);
        pClip.addChild(pNode);
        pClip.addChild(this._stateLayer);
        pClip.addChild(this._squiggleLayer);
        pClip.addChild(this._electronNode);
        pNode.setOffset(10.0, 10.0);
        double d4 = 10.0 + pNode.getFullBounds().getWidth();
        double d5 = 0.0;
        double d6 = pClip.getWidth() - d4;
        double d7 = pClip.getHeight();
        this._drawingArea = new Rectangle2D.Double(d4, d5, d6, d7);
        this._energies = AbstractEnergyDiagram.calculateEnergies(n);
    }

    public void addCloseListener(ActionListener actionListener) {
        this._closeButton.addActionListener(actionListener);
    }

    protected ElectronNode getElectronNode() {
        return this._electronNode;
    }

    protected Rectangle2D getDrawingArea() {
        return this._drawingArea;
    }

    protected PLayer getStateLayer() {
        return this._stateLayer;
    }

    protected PLayer getSquiggleLayer() {
        return this._squiggleLayer;
    }

    protected double getEnergy(int n) {
        return this._energies[n - 1];
    }

    private static double[] calculateEnergies(int n) {
        int n2;
        double[] dArray = new double[n];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            int n3 = n2 + 1;
            dArray[n2] = -13.6 / (double)(n3 * n3);
        }
        for (n2 = 1; n2 < dArray.length - 1; ++n2) {
            dArray[n2] = dArray[n2] * 1.2;
        }
        return dArray;
    }

    protected static PNode createStateLineNode() {
        PPath pPath = new PPath(new Line2D.Double(0.0, 0.0, 10.0, 0.0));
        pPath.setStroke(LINE_STROKE);
        pPath.setStrokePaint(LINE_COLOR);
        return pPath;
    }

    protected static PNode createStateLabelNode(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        String string = MessageFormat.format("n={0}", objectArray);
        PText pText = new PText(string);
        pText.setFont(LABEL_FONT);
        pText.setTextPaint(LABEL_COLOR);
        return pText;
    }

    private static PNode createAxisNode(double d, Font font) {
        PPath pPath = new PPath();
        pPath.setPathTo(new Line2D.Double(0.0, AbstractEnergyDiagram.AXIS_ARROW_SIZE.height - 1, 0.0, d));
        pPath.setStroke(new BasicStroke(2.0f));
        pPath.setStrokePaint(AXIS_COLOR);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(AbstractEnergyDiagram.AXIS_ARROW_SIZE.width / 2, AbstractEnergyDiagram.AXIS_ARROW_SIZE.height);
        generalPath.lineTo(-AbstractEnergyDiagram.AXIS_ARROW_SIZE.width / 2, AbstractEnergyDiagram.AXIS_ARROW_SIZE.height);
        generalPath.closePath();
        PPath pPath2 = new PPath(generalPath);
        pPath2.setPaint(AXIS_COLOR);
        pPath2.setStroke(null);
        PText pText = new PText(HAResources.getString("label.energyDiagram.yAxis"));
        pText.setFont(font);
        pText.setTextPaint(AXIS_LABEL_COLOR);
        pText.rotate(Math.toRadians(-90.0));
        PComposite pComposite = new PComposite();
        pComposite.addChild(pPath);
        pComposite.addChild(pPath2);
        pComposite.addChild(pText);
        double d2 = 0.0;
        double d3 = d;
        pText.setOffset(d2, d3);
        d2 = pText.getFullBounds().getWidth() + 3.0;
        d3 = 0.0;
        pPath.setOffset(d2, d3);
        pPath2.setOffset(d2, d3);
        return pComposite;
    }
}

