/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.control;

import edu.colorado.phet.common.phetcommon.view.controls.IntensitySlider;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class IntensityControl
extends JPanel {
    private IntensitySlider _slider;
    private JFormattedTextField _formattedTextField;
    private JLabel _units;
    private EventListenerList _listenerList = new EventListenerList();
    private Object _eventSource = this;

    public IntensityControl(Dimension dimension, Font font) {
        EventHandler eventHandler = new EventHandler();
        this._slider = new IntensitySlider(Color.RED, IntensitySlider.HORIZONTAL, dimension);
        this._slider.addChangeListener(eventHandler);
        this._formattedTextField = new JFormattedTextField();
        this._formattedTextField.setFont(font);
        this._formattedTextField.setColumns(3);
        this._formattedTextField.setHorizontalAlignment(4);
        this._formattedTextField.addActionListener(eventHandler);
        this._formattedTextField.addFocusListener(eventHandler);
        this._formattedTextField.addKeyListener(eventHandler);
        this._units = new JLabel("%");
        this._units.setFont(font);
        this.setOpaque(false);
        this._slider.setOpaque(false);
        this._units.setOpaque(false);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        easyGridBagLayout.setInsets(new Insets(0, 0, 0, 3));
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._slider, n, n2++);
        easyGridBagLayout.addComponent(this._formattedTextField, n, n2++);
        easyGridBagLayout.addComponent(this._units, n, n2++);
        this.setValue(0);
    }

    public void setColor(Color color) {
        this._slider.setColor(color);
    }

    public void setValue(int n) {
        this._slider.setValue(n);
        this.updateTextField();
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public int getValue() {
        return this._slider.getValue();
    }

    public void setUnitsForeground(Color color) {
        this._units.setForeground(color);
    }

    private void updateSlider() {
        boolean bl = false;
        String string = this._formattedTextField.getText();
        try {
            int n = Integer.parseInt(string);
            if (n >= this._slider.getMinimum() && n <= this._slider.getMaximum()) {
                this._slider.setValue(n);
            } else {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (bl) {
            this.warnUser();
            this.updateTextField();
        }
    }

    private void updateTextField() {
        int n = this._slider.getValue();
        String string = "" + n;
        this._formattedTextField.setText(string);
    }

    private void warnUser() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private class EventHandler
    extends KeyAdapter
    implements ActionListener,
    FocusListener,
    ChangeListener {
        private EventHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == IntensityControl.this._formattedTextField) {
                if (keyEvent.getKeyCode() == 38) {
                    int n = IntensityControl.this._slider.getValue() + 1;
                    IntensityControl.this.setValue(n);
                } else if (keyEvent.getKeyCode() == 40) {
                    int n = IntensityControl.this._slider.getValue() - 1;
                    IntensityControl.this.setValue(n);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == IntensityControl.this._formattedTextField) {
                IntensityControl.this.updateSlider();
                IntensityControl.this.fireChangeEvent(new ChangeEvent(IntensityControl.this._eventSource));
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == IntensityControl.this._slider) {
                IntensityControl.this.updateTextField();
                IntensityControl.this.fireChangeEvent(new ChangeEvent(IntensityControl.this._eventSource));
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == IntensityControl.this._formattedTextField) {
                IntensityControl.this._formattedTextField.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == IntensityControl.this._formattedTextField) {
                try {
                    IntensityControl.this._formattedTextField.commitEdit();
                    IntensityControl.this.updateSlider();
                }
                catch (ParseException parseException) {
                    IntensityControl.this.warnUser();
                    IntensityControl.this.updateTextField();
                }
            }
        }
    }
}

