/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.control;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.control.GunTypeControl;
import edu.colorado.phet.hydrogenatom.control.IntensityControl;
import edu.colorado.phet.hydrogenatom.control.LightTypeControl;
import edu.colorado.phet.hydrogenatom.control.TracesControl;
import edu.colorado.phet.hydrogenatom.control.TransitionMarksControl;
import edu.colorado.phet.hydrogenatom.enums.GunMode;
import edu.colorado.phet.hydrogenatom.enums.LightType;
import edu.colorado.phet.hydrogenatom.hacks.GunWavelengthControl;
import edu.colorado.phet.hydrogenatom.model.Gun;
import edu.colorado.phet.hydrogenatom.view.TracesNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GunControlPanel
extends PhetPNode
implements Observer {
    private static final Dimension INTENSITY_CONTROL_SIZE = new Dimension(175, 20);
    private static final Color LABEL_COLOR = Color.WHITE;
    private Gun _gun;
    private TracesNode _tracesNode;
    private GunTypeControl _gunTypeControl;
    private PhetPNode _lightControls;
    private LightTypeControl _lightTypeControl;
    private IntensityControl _lightIntensityControl;
    private GunWavelengthControl _wavelengthControl;
    private TransitionMarksControl _transitionMarksControl;
    private PSwing _transitionMarksControlWrapper;
    private boolean _transitionMarksControlVisible;
    private PhetPNode _alphaParticleControls;
    private IntensityControl _alphaParticlesIntensityControl;
    private TracesControl _alphaParticlesTracesControl;

    public GunControlPanel(Gun gun, TracesNode tracesNode) {
        this._gun = gun;
        this._tracesNode = tracesNode;
        this._transitionMarksControlVisible = false;
        int n = HAResources.getInt("gunControls.font.size", 16);
        PhetFont phetFont = new PhetFont(1, n);
        PImage pImage = HAResources.getImageNode("gunPanel.png");
        JLabel jLabel = new JLabel(HAResources.getString("label.lightControls"));
        PhetFont phetFont2 = new PhetFont(1, n + 2);
        jLabel.setFont(phetFont2);
        PSwing pSwing = new PSwing(jLabel);
        this._gunTypeControl = new GunTypeControl(phetFont);
        this._lightControls = new PhetPNode();
        this._lightTypeControl = new LightTypeControl(phetFont);
        this._lightIntensityControl = new IntensityControl(INTENSITY_CONTROL_SIZE, phetFont);
        this._wavelengthControl = new GunWavelengthControl(this._gun.getMinWavelength(), this._gun.getMaxWavelength(), HAConstants.UV_TRACK_COLOR, HAConstants.UV_LABEL_COLOR, HAConstants.IR_TRACK_COLOR, HAConstants.IR_LABEL_COLOR);
        this._transitionMarksControl = new TransitionMarksControl(phetFont);
        this._alphaParticleControls = new PhetPNode();
        this._alphaParticlesIntensityControl = new IntensityControl(INTENSITY_CONTROL_SIZE, phetFont);
        this._alphaParticlesIntensityControl.setColor(HAConstants.ALPHA_PARTICLES_COLOR);
        this._alphaParticlesTracesControl = new TracesControl(phetFont);
        PSwing pSwing2 = new PSwing(this._lightTypeControl);
        PSwing pSwing3 = new PSwing(this._lightIntensityControl);
        this._transitionMarksControlWrapper = new PSwing(this._transitionMarksControl);
        PSwing pSwing4 = new PSwing(this._alphaParticlesIntensityControl);
        PSwing pSwing5 = new PSwing(this._alphaParticlesTracesControl);
        this._lightControls.addChild(pSwing2);
        this._lightControls.addChild(this._wavelengthControl);
        this._lightControls.addChild(this._transitionMarksControlWrapper);
        this._alphaParticleControls.addChild(pSwing5);
        this.addChild(pImage);
        this.addChild(pSwing);
        this.addChild(this._lightControls);
        this.addChild(this._alphaParticleControls);
        pSwing.setOffset(40.0, 10.0);
        Object object = pSwing.getFullBounds();
        this._lightControls.setOffset(((Rectangle2D.Double)object).getX(), ((Rectangle2D.Double)object).getY() + ((Rectangle2D.Double)object).getHeight() + 5.0);
        pSwing2.setOffset(0.0, 0.0);
        PBounds pBounds = pSwing2.getFullBounds();
        double d = 10.0;
        double d2 = 25.0;
        this._wavelengthControl.setOffset(pBounds.getX() + d, pBounds.getY() + pBounds.getHeight() + 5.0 + d2);
        double d3 = pBounds.getX();
        pBounds = this._wavelengthControl.getFullBounds();
        this._transitionMarksControlWrapper.setOffset(d3, pBounds.getY() + pBounds.getHeight() + 5.0);
        this._alphaParticleControls.setOffset(((Rectangle2D.Double)object).getX(), ((Rectangle2D.Double)object).getY() + ((Rectangle2D.Double)object).getHeight() + 5.0);
        pSwing5.setOffset(0.0, 0.0);
        this._wavelengthControl.setWavelength(780.0);
        this._wavelengthControl.setTextFieldFont(phetFont);
        this._wavelengthControl.setUnitsFont(phetFont);
        object = pImage.getFullBounds();
        pBounds = pSwing.getFullBounds();
        PBounds pBounds2 = this._lightControls.getFullBounds();
        PBounds pBounds3 = this._alphaParticleControls.getFullBounds();
        d2 = 30.0;
        d3 = Math.max(pBounds.getWidth(), Math.max(pBounds2.getWidth() - d2, pBounds3.getWidth())) + 80.0;
        double d4 = pBounds.getHeight() + 5.0 + Math.max(pBounds2.getHeight(), pBounds3.getHeight()) + 20.0;
        double d5 = d3 / ((Rectangle2D.Double)object).getWidth();
        double d6 = d4 / ((Rectangle2D.Double)object).getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d5, d6);
        pImage.setTransform(affineTransform);
        this._gunTypeControl.setLabelsForeground(LABEL_COLOR);
        jLabel.setForeground(LABEL_COLOR);
        this._lightTypeControl.setLabelsForeground(LABEL_COLOR);
        this._lightIntensityControl.setUnitsForeground(LABEL_COLOR);
        this._wavelengthControl.setUnitsForeground(LABEL_COLOR);
        this._transitionMarksControl.setForeground(LABEL_COLOR);
        this._alphaParticlesIntensityControl.setUnitsForeground(LABEL_COLOR);
        this._alphaParticlesTracesControl.setForeground(LABEL_COLOR);
        pImage.setPickable(false);
        object = new GunChangeListener();
        this._transitionMarksControl.addActionListener((ActionListener)object);
        this._gunTypeControl.addChangeListener((ChangeListener)object);
        this._lightTypeControl.addChangeListener((ChangeListener)object);
        this._lightIntensityControl.addChangeListener((ChangeListener)object);
        this._wavelengthControl.addChangeListener((ChangeListener)object);
        this._alphaParticlesIntensityControl.addChangeListener((ChangeListener)object);
        this._alphaParticlesTracesControl.addChangeListener((ChangeListener)object);
        this._gunTypeControl.addInputEventListener(new CursorHandler());
        pSwing2.addInputEventListener(new CursorHandler());
        pSwing3.addInputEventListener(new CursorHandler());
        this._transitionMarksControlWrapper.addInputEventListener(new CursorHandler());
        pSwing4.addInputEventListener(new CursorHandler());
        pSwing5.addInputEventListener(new CursorHandler());
        this.updateAll();
        this._wavelengthControl.setTransitionMarksVisible(false);
        this._transitionMarksControlWrapper.setVisible(this._transitionMarksControlVisible);
        this._gun.addObserver(this);
    }

    public void updateWavelengthControlDragBounds() {
        this._wavelengthControl.updateDragBounds();
    }

    public void setTransitionWavelengths(double[] dArray) {
        this._wavelengthControl.setTransitionWavelengths(dArray);
        this._wavelengthControl.setKnobHilitingEnabled(true);
        boolean bl = this._transitionMarksControlVisible = dArray != null;
        if (this._lightTypeControl.isMonochromaticSelected()) {
            this._transitionMarksControlWrapper.setVisible(this._transitionMarksControlVisible);
        } else {
            this._transitionMarksControlWrapper.setVisible(false);
        }
    }

    private void handleGunTypeChange() {
        this._tracesNode.setEnabled(this._gun.isAlphaParticlesMode() && this._alphaParticlesTracesControl.isSelected());
        this._lightControls.setVisible(this._gun.isPhotonsMode());
        this._alphaParticleControls.setVisible(this._gun.isAlphaParticlesMode());
        GunMode gunMode = this._gunTypeControl.isPhotonsSelected() ? GunMode.PHOTONS : GunMode.ALPHA_PARTICLES;
        this._gun.setMode(gunMode);
    }

    private void handleLightTypeChange() {
        LightType lightType = null;
        if (this._lightTypeControl.isMonochromaticSelected()) {
            this._lightIntensityControl.setColor(this._wavelengthControl.getWavelengthColor());
            this._wavelengthControl.setVisible(true);
            this._transitionMarksControlWrapper.setVisible(this._transitionMarksControlVisible);
            lightType = LightType.MONOCHROMATIC;
        } else {
            this._lightIntensityControl.setColor(Color.WHITE);
            this._wavelengthControl.setVisible(false);
            this._transitionMarksControlWrapper.setVisible(false);
            lightType = LightType.WHITE;
        }
        this._gun.setLightType(lightType);
    }

    private void handleLightIntensityChange() {
        double d = (double)this._lightIntensityControl.getValue() / 100.0;
        this._gun.setLightIntensity(d);
    }

    private void handleWavelengthChange() {
        if (this._gun.isMonochromaticLightType()) {
            this._lightIntensityControl.setColor(this._wavelengthControl.getWavelengthColor());
        }
        this._gun.setWavelength(this._wavelengthControl.getWavelength());
    }

    private void handleTransitionMarksChange() {
        this._wavelengthControl.setTransitionMarksVisible(this._transitionMarksControl.isSelected());
    }

    private void handleAlphaParticlesIntensityChange() {
        double d = (double)this._alphaParticlesIntensityControl.getValue() / 100.0;
        this._gun.setAlphaParticlesIntensity(d);
    }

    private void handleAlphaParticlesTraceChange() {
        this._tracesNode.setEnabled(this._alphaParticlesTracesControl.isSelected());
    }

    public void update(Observable observable, Object object) {
        if (observable == this._gun) {
            if (object == "mode") {
                this._gunTypeControl.setPhotonsSelected(this._gun.isPhotonsMode());
            } else if (object == "lightType") {
                this._lightTypeControl.setMonochromaticSelected(this._gun.isMonochromaticLightType());
            } else if (object == "waveLength") {
                this._wavelengthControl.setWavelength(this._gun.getWavelength());
            } else if (object == "lightIntensity") {
                int n = (int)(100.0 * this._gun.getLightIntensity());
                this._lightIntensityControl.setValue(n);
            } else if (object == "alphaParticlesIntensity") {
                int n = (int)(100.0 * this._gun.getAlphaParticlesIntensity());
                this._alphaParticlesIntensityControl.setValue(n);
            }
        }
    }

    private void updateAll() {
        this._gunTypeControl.setPhotonsSelected(this._gun.isPhotonsMode());
        this._lightControls.setVisible(this._gun.isPhotonsMode());
        this._alphaParticleControls.setVisible(this._gun.isAlphaParticlesMode());
        if (this._gun.isMonochromaticLightType()) {
            this._lightTypeControl.setMonochromaticSelected(true);
            this._lightIntensityControl.setColor(this._wavelengthControl.getWavelengthColor());
            this._wavelengthControl.setVisible(true);
        } else {
            this._lightTypeControl.setWhiteSelected(true);
            this._lightIntensityControl.setColor(Color.WHITE);
            this._wavelengthControl.setVisible(false);
        }
        this._wavelengthControl.setWavelength(this._gun.getWavelength());
        this._lightIntensityControl.setValue((int)(100.0 * this._gun.getLightIntensity()));
        this._alphaParticlesIntensityControl.setValue((int)(100.0 * this._gun.getAlphaParticlesIntensity()));
        this._alphaParticlesTracesControl.setSelected(this._tracesNode.isEnabled());
    }

    private class GunChangeListener
    implements ActionListener,
    ChangeListener {
        private GunChangeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == GunControlPanel.this._transitionMarksControl) {
                GunControlPanel.this.handleTransitionMarksChange();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == GunControlPanel.this._gunTypeControl) {
                GunControlPanel.this.handleGunTypeChange();
            } else if (object == GunControlPanel.this._lightTypeControl) {
                GunControlPanel.this.handleLightTypeChange();
            } else if (object == GunControlPanel.this._lightIntensityControl) {
                GunControlPanel.this.handleLightIntensityChange();
            } else if (object == GunControlPanel.this._wavelengthControl) {
                GunControlPanel.this.handleWavelengthChange();
            } else if (object == GunControlPanel.this._alphaParticlesIntensityControl) {
                GunControlPanel.this.handleAlphaParticlesIntensityChange();
            } else if (object == GunControlPanel.this._alphaParticlesTracesControl) {
                GunControlPanel.this.handleAlphaParticlesTraceChange();
            }
        }
    }
}

