/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.control;

import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.enums.AtomicModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class AtomicModelSelector
extends PhetPNode {
    private static final Color TITLE_COLOR = Color.BLACK;
    private static final Color CONTINUUM_CLASSICAL_COLOR = Color.WHITE;
    private static final Color CONTINUUM_QUANTUM_COLOR = Color.BLACK;
    private static final Color BUTTON_SELECTED_COLOR = Color.WHITE;
    private static final Color BUTTON_DESELECTED_COLOR = Color.BLACK;
    private final ArrayList<ButtonNode> buttons = new ArrayList();
    private final PPath _selectionIndicator;
    private final EventListenerList _listenerList;
    private AtomicModel _selectedModel;

    public AtomicModelSelector() {
        PhetFont phetFont = new PhetFont(1, HAResources.getInt("atomicModelSelector.title.font.size", 16));
        PhetFont phetFont2 = new PhetFont(0, HAResources.getInt("atomicModelSelector.continuum.font.size", 16));
        PhetFont phetFont3 = new PhetFont(1, HAResources.getInt("atomicModelSelector.button.font.size", 16));
        PImage pImage = HAResources.getImageNode("atomicModelPanel.png");
        HTMLNode hTMLNode = new HTMLNode(HAResources.getString("label.atomicModel"));
        hTMLNode.setFont(phetFont);
        hTMLNode.setHTMLColor(TITLE_COLOR);
        PText pText = new PText(HAResources.getString("label.classical"));
        pText.setFont(phetFont2);
        pText.setTextPaint(CONTINUUM_QUANTUM_COLOR);
        PText pText2 = new PText(HAResources.getString("label.quantum"));
        pText2.setFont(phetFont2);
        pText2.setTextPaint(CONTINUUM_CLASSICAL_COLOR);
        VoidFunction1<AtomicModel> voidFunction1 = new VoidFunction1<AtomicModel>(){

            @Override
            public void apply(AtomicModel atomicModel) {
                AtomicModelSelector.this.setSelection(atomicModel);
            }
        };
        this.buttons.add(new ButtonNode(AtomicModel.BILLIARD_BALL, "button.billiardBall", phetFont3, "billiardBallButton.png", voidFunction1));
        this.buttons.add(new ButtonNode(AtomicModel.PLUM_PUDDING, "button.plumPudding", phetFont3, "plumPuddingButton.png", voidFunction1));
        this.buttons.add(new ButtonNode(AtomicModel.SOLAR_SYSTEM, "button.solarSystem", phetFont3, "solarSystemButton.png", voidFunction1));
        this.buttons.add(new ButtonNode(AtomicModel.BOHR, "button.bohr", phetFont3, "bohrButton.png", voidFunction1));
        this.buttons.add(new ButtonNode(AtomicModel.DEBROGLIE, "button.deBroglie", phetFont3, "deBroglieButton.png", voidFunction1));
        this.buttons.add(new ButtonNode(AtomicModel.SCHRODINGER, "button.schrodinger", phetFont3, "schrodingerButton.png", voidFunction1));
        double d = 0.0;
        double d2 = 0.0;
        double d3 = pText.getFullBounds().getHeight();
        double d4 = pText2.getFullBounds().getHeight();
        d = Math.max(d3, d4) + 2.0;
        d2 = 0.0;
        for (ButtonNode cloneable2 : this.buttons) {
            d2 += cloneable2.getFullBoundsReference().getHeight();
        }
        d2 += (double)(this.buttons.size() - 1) * 10.0;
        d3 = hTMLNode.getFullBoundsReference().getWidth();
        for (ButtonNode buttonNode : this.buttons) {
            d3 = Math.max(d3, buttonNode.getFullBoundsReference().getWidth());
        }
        double d5 = d3 + 3.0 + d + 16.0;
        double d6 = 5.0 + hTMLNode.getFullBoundsReference().getHeight() + 10.0 + d2 + 5.0;
        Object object = pImage.getFullBounds();
        double d7 = d5 / ((Rectangle2D.Double)object).getWidth();
        double d8 = (d6 += 10.0) / ((Rectangle2D.Double)object).getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d7, d8);
        pImage.setTransform(affineTransform);
        this._selectionIndicator = new PPath();
        d3 = pImage.getFullBounds().getWidth() - d - 3.0 - 16.0;
        d5 = this.buttons.get(0).getImageHeight() + 4.0;
        this._selectionIndicator.setPathTo(new Rectangle2D.Double(0.0, 0.0, d3, d5));
        this._selectionIndicator.setPaint(BUTTON_SELECTED_COLOR);
        this._selectionIndicator.setStroke(null);
        PComposite pComposite = new PComposite();
        double d9 = d2;
        double d10 = d;
        PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, d9, d10));
        pPath.setStroke(null);
        object = new GradientPaint(0.0f, 0.0f, CONTINUUM_CLASSICAL_COLOR, (float)d9, 0.0f, CONTINUUM_QUANTUM_COLOR);
        pPath.setPaint((Paint)object);
        pComposite.addChild(pPath);
        pComposite.addChild(pText);
        pComposite.addChild(pText2);
        pPath.setOffset(0.0, 0.0);
        pText.setOffset(5.0, (pPath.getFullBounds().getHeight() - pText.getFullBounds().getHeight()) / 2.0);
        pText2.setOffset(pPath.getFullBounds().getWidth() - pText2.getFullBounds().getWidth() - 5.0, (pPath.getFullBounds().getHeight() - pText2.getFullBounds().getHeight()) / 2.0);
        this.addChild(pImage);
        this.addChild(hTMLNode);
        this.addChild(this._selectionIndicator);
        for (ButtonNode buttonNode : this.buttons) {
            this.addChild(buttonNode);
        }
        this.addChild(pComposite);
        pImage.setOffset(0.0, 0.0);
        double d11 = pImage.getFullBounds().getWidth();
        hTMLNode.setOffset((d11 - hTMLNode.getFullBounds().getWidth()) / 2.0, 5.0);
        PNode pNode = hTMLNode;
        for (ButtonNode buttonNode : this.buttons) {
            this.setOffsetCentered(buttonNode, pNode, pImage, pComposite, 10.0);
            pNode = buttonNode;
        }
        PBounds pBounds = pImage.getFullBounds();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(pBounds.getWidth() - pComposite.getFullBounds().getHeight() - 8.0, this.buttons.get(0).getFullBounds().getY());
        affineTransform2.rotate(Math.toRadians(90.0));
        affineTransform2.translate(0.0, -pComposite.getFullBounds().getHeight());
        pComposite.setTransform(affineTransform2);
        this._listenerList = new EventListenerList();
        pImage.setPickable(false);
        pComposite.setPickable(false);
        hTMLNode.setPickable(false);
        pText.setPickable(false);
        pText2.setPickable(false);
        this._selectionIndicator.setPickable(false);
        this.setSelection(AtomicModel.BILLIARD_BALL);
    }

    private void setOffsetCentered(PNode pNode, PNode pNode2, PNode pNode3, PNode pNode4, double d) {
        double d2 = (pNode3.getFullBounds().getWidth() - pNode4.getFullBounds().getHeight() - 3.0 - pNode.getFullBounds().getWidth()) / 2.0;
        double d3 = pNode2.getFullBounds().getMaxY() + d;
        pNode.setOffset(d2, d3);
    }

    public void setSelection(AtomicModel atomicModel) {
        this._selectedModel = atomicModel;
        this.updateUI();
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public AtomicModel getSelection() {
        return this._selectedModel;
    }

    public String getSelectionName() {
        String string = null;
        if (this._selectedModel == AtomicModel.BILLIARD_BALL) {
            string = "label.billiardBall";
        } else if (this._selectedModel == AtomicModel.PLUM_PUDDING) {
            string = "label.plumPudding";
        } else if (this._selectedModel == AtomicModel.SOLAR_SYSTEM) {
            string = "label.solarSystem";
        } else if (this._selectedModel == AtomicModel.BOHR) {
            string = "label.bohr";
        } else if (this._selectedModel == AtomicModel.DEBROGLIE) {
            string = "label.deBroglie";
        } else if (this._selectedModel == AtomicModel.SCHRODINGER) {
            string = "label.schrodinger";
        }
        return HAResources.getString(string);
    }

    private ButtonNode getSelectedButton() {
        ButtonNode buttonNode = null;
        for (ButtonNode buttonNode2 : this.buttons) {
            if (buttonNode2.getModel() != this._selectedModel) continue;
            buttonNode = buttonNode2;
        }
        assert (buttonNode != null);
        return buttonNode;
    }

    private void updateUI() {
        for (ButtonNode cloneable2 : this.buttons) {
            cloneable2.setSelection(this._selectedModel);
        }
        PBounds pBounds = this.getSelectedButton().getFullBounds();
        PBounds pBounds2 = this._selectionIndicator.getFullBounds();
        double d = pBounds.getX() - (pBounds2.getWidth() - pBounds.getWidth()) / 2.0;
        double d2 = pBounds.getMaxY() - pBounds2.getHeight() + (pBounds2.getHeight() - this.getSelectedButton().getImageHeight()) / 2.0;
        this._selectionIndicator.setOffset(d, d2);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ButtonNode
    extends PNode {
        private final AtomicModel model;
        private final HTMLNode htmlNode;
        private final PImage imageNode;

        public ButtonNode(final AtomicModel atomicModel, String string, Font font, String string2, final VoidFunction1<AtomicModel> voidFunction1) {
            this.model = atomicModel;
            this.htmlNode = new HTMLNode(HAResources.getString(string));
            this.htmlNode.setFont(font);
            this.addChild(this.htmlNode);
            this.imageNode = new PImage(HAResources.getImage(string2));
            this.addChild(this.imageNode);
            double d = Math.max(this.htmlNode.getFullBounds().getWidth(), this.imageNode.getFullBoundsReference().getWidth());
            double d2 = d / 2.0 - this.htmlNode.getFullBoundsReference().getWidth() / 2.0;
            double d3 = 0.0;
            this.htmlNode.setOffset(d2, d3);
            d2 = d / 2.0 - this.imageNode.getFullBoundsReference().getWidth() / 2.0;
            d3 = this.htmlNode.getFullBoundsReference().getMaxY() + 4.0;
            this.imageNode.setOffset(d2, d3);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    voidFunction1.apply(atomicModel);
                }
            });
        }

        public void setSelection(AtomicModel atomicModel) {
            this.htmlNode.setHTMLColor(atomicModel == this.model ? BUTTON_SELECTED_COLOR : BUTTON_DESELECTED_COLOR);
        }

        public AtomicModel getModel() {
            return this.model;
        }

        public double getImageHeight() {
            return this.imageNode.getFullBoundsReference().getHeight();
        }
    }
}

