/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SpectrumImageFactory;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.ConstrainedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class WavelengthControl
extends PhetPNode {
    private static final Dimension KNOB_SIZE = new Dimension(20, 20);
    private static final Stroke KNOB_STROKE = new BasicStroke(1.0f);
    private static final Color KNOB_STROKE_COLOR = Color.WHITE;
    private static final DecimalFormat VALUE_FORMAT = new DecimalFormat("0");
    private static final Stroke CURSOR_STROKE = new BasicStroke(1.0f);
    private static final Color CURSOR_COLOR = Color.BLACK;
    private static final Color UV_TRACK_COLOR = Color.LIGHT_GRAY;
    private static final Color UV_LABEL_COLOR = Color.BLACK;
    private static final Color IR_TRACK_COLOR = UV_TRACK_COLOR;
    private static final Color IR_LABEL_COLOR = UV_LABEL_COLOR;
    private final double _minWavelength;
    private final double _maxWavelength;
    private final Color _uvColor;
    private final Color _irColor;
    private final Knob _knob;
    private final Track _track;
    private final PPath _trackBorder;
    private final ValueDisplay _valueDisplay;
    private final Cursor _cursor;
    private ConstrainedDragHandler _dragHandler;
    private final EventListenerList _listenerList;
    private double _wavelength;

    public WavelengthControl(int n, int n2, double d, double d2, Color color, Color color2, Color color3, Color color4) {
        if (d >= d2) {
            throw new IllegalArgumentException("have you reversed the minWavelength and maxWavelength args?");
        }
        this._minWavelength = d;
        this._maxWavelength = d2;
        this._wavelength = this._minWavelength - 1.0;
        this._uvColor = color;
        this._irColor = color3;
        this._listenerList = new EventListenerList();
        this._knob = new Knob(WavelengthControl.KNOB_SIZE.width, WavelengthControl.KNOB_SIZE.height);
        this._track = new Track(n, n2, d, d2, color, color2, color3, color4);
        this._valueDisplay = new ValueDisplay();
        this._cursor = new Cursor(3.0, this._track.getFullBounds().getHeight());
        this._trackBorder = new PPath();
        this._trackBorder.setPathTo(new Rectangle2D.Double(0.0, 0.0, this._track.getFullBounds().getWidth(), this._track.getFullBounds().getHeight()));
        this._trackBorder.setStroke(new BasicStroke(1.0f));
        this._trackBorder.setStrokePaint(Color.BLACK);
        this.addChild(this._track);
        this.addChild(this._trackBorder);
        this.addChild(this._valueDisplay);
        this.addChild(this._cursor);
        this.addChild(this._knob);
        this._track.setOffset(0.0, 0.0);
        this._track.addInputEventListener(new CursorHandler());
        this._track.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                WavelengthControl.this.handleTrackClick(pInputEvent.getPositionRelativeTo(WavelengthControl.this._track));
            }
        });
        this._dragHandler = new ConstrainedDragHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                super.mouseDragged(pInputEvent);
                WavelengthControl.this.handleKnobDrag();
            }
        };
        this._dragHandler.setVerticalLockEnabled(true);
        this._dragHandler.setTreatAsPointEnabled(true);
        this.updateDragBounds();
        this._knob.addInputEventListener(this._dragHandler);
        this._knob.addInputEventListener(new CursorHandler());
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("fullBounds".equals(propertyChangeEvent.getPropertyName())) {
                    WavelengthControl.this.updateDragBounds();
                }
            }
        });
        this._valueDisplay.addInputEventListener(new CursorHandler());
        this.setWavelength(this._minWavelength);
    }

    public double getMinWavelength() {
        return this._minWavelength;
    }

    public double getMaxWavelength() {
        return this._maxWavelength;
    }

    public void setWavelength(double d) {
        if (d < this._minWavelength || d > this._maxWavelength) {
            throw new IllegalArgumentException("wavelength out of range: " + d);
        }
        if (d != this._wavelength) {
            this._wavelength = d;
            this.updateUI();
            this.fireChangeEvent(new ChangeEvent(this));
        }
    }

    public double getWavelength() {
        return this._wavelength;
    }

    public Color getWavelengthColor(double d) {
        Color color = null;
        color = d < 380.0 ? this._uvColor : (d > 780.0 ? this._irColor : VisibleColor.wavelengthToColor(d));
        return color;
    }

    public Color getWavelengthColor() {
        return this.getWavelengthColor(this._wavelength);
    }

    public void setTextFieldFont(Font font) {
        this._valueDisplay.getFormattedTextField().setFont(font);
        this._valueDisplay.computeBounds();
        this.updateUI();
    }

    public void setUnitsForeground(Color color) {
        this._valueDisplay.getUnitsLabel().setForeground(color);
    }

    public void setUnitsFont(Font font) {
        this._valueDisplay.getUnitsLabel().setFont(font);
        this._valueDisplay.computeBounds();
        this.updateUI();
    }

    public void setCursorColor(Color color) {
        this._cursor.setStrokePaint(color);
    }

    public void setKnobStroke(Stroke stroke) {
        this._knob.setStroke(stroke);
    }

    public void setKnobStrokeColor(Color color) {
        this._knob.setStrokePaint(color);
    }

    public void addKnobListener(PInputEventListener pInputEventListener) {
        this._knob.addInputEventListener(pInputEventListener);
    }

    protected PNode getTrackBorder() {
        return this._trackBorder;
    }

    protected PBounds getTrackFullBounds() {
        return this._track.getFullBounds();
    }

    private double calculateWavelength() {
        double d = this._maxWavelength - this._minWavelength;
        PBounds pBounds = this._track.getFullBounds();
        PBounds pBounds2 = this._knob.getFullBounds();
        double d2 = pBounds.getX();
        double d3 = pBounds.getWidth();
        double d4 = pBounds2.getX() + pBounds2.getWidth() / 2.0;
        double d5 = this._minWavelength + (d4 - d2) / d3 * d;
        return d5;
    }

    private void handleKnobDrag() {
        double d = this.calculateWavelength();
        d = MathUtil.clamp(this._minWavelength, d, this._maxWavelength);
        this.setWavelength(d);
    }

    private void handleTextEntry() {
        double d = this._valueDisplay.getValue();
        if (d >= this._minWavelength && d <= this._maxWavelength) {
            this.setWavelength(d);
        } else {
            this.warnUser();
            this._valueDisplay.setValue(this._wavelength);
            this._valueDisplay.selectAll();
        }
    }

    private void handleTrackClick(Point2D point2D) {
        double d = this._maxWavelength - this._minWavelength;
        double d2 = this._track.getFullBounds().getWidth();
        double d3 = this._minWavelength + point2D.getX() / d2 * d;
        this.setWavelength(d3);
    }

    private void updateUI() {
        double d = this._maxWavelength - this._minWavelength;
        PBounds pBounds = this._track.getFullBounds();
        double d2 = this._knob.getFullBounds().getWidth();
        double d3 = this._cursor.getFullBounds().getWidth();
        double d4 = this._valueDisplay.getFullBounds().getWidth();
        double d5 = this._valueDisplay.getFullBounds().getHeight();
        Color color = this.getWavelengthColor();
        this._knob.setPaint(color);
        double d6 = pBounds.getX();
        double d7 = pBounds.getWidth();
        double d8 = d6 + d7 * ((this._wavelength - this._minWavelength) / d);
        double d9 = pBounds.getHeight();
        this._knob.setOffset(d8, d9);
        this._valueDisplay.setValue(this._wavelength);
        double d10 = d8 - d4 / 2.0;
        double d11 = -(d5 + 2.0);
        this._valueDisplay.setOffset(d10, d11);
        this._cursor.setOffset(d8, 0.0);
    }

    public void updateDragBounds() {
        PBounds pBounds = this._track.getGlobalFullBounds();
        PBounds pBounds2 = this._knob.getGlobalFullBounds();
        Rectangle2D.Double double_ = new Rectangle2D.Double(pBounds.getX() - pBounds2.getWidth() / 2.0, pBounds.getY(), pBounds.getWidth(), pBounds.getHeight());
        this._dragHandler.setDragBounds(double_);
    }

    private void warnUser() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private static class Cursor
    extends PPath {
        public Cursor(double d, double d2) {
            this.setPathTo(new Rectangle2D.Double(-d / 2.0, 0.0, d, d2));
            this.setStroke(CURSOR_STROKE);
            this.setStrokePaint(CURSOR_COLOR);
        }
    }

    private static class Knob
    extends PPath {
        public Knob(float f, float f2) {
            this.setStroke(KNOB_STROKE);
            this.setPaint(KNOB_STROKE_COLOR);
            this.setSize(f, f2);
        }

        public void setSize(float f, float f2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(0.5f * f, 0.3f * f2);
            generalPath.lineTo(0.5f * f, 1.0f * f2);
            generalPath.lineTo(-0.5f * f, 1.0f * f2);
            generalPath.lineTo(-0.5f * f, 0.3f * f2);
            generalPath.closePath();
            this.setPathTo(generalPath);
        }
    }

    private static class Track
    extends PComposite {
        public Track(int n, int n2, double d, double d2, Color color, Color color2, Color color3, Color color4) {
            PText pText;
            double d3 = d2 - d;
            double d4 = 380.0 - d;
            double d5 = d2 - 780.0;
            double d6 = d4 / d3 * (double)n;
            double d7 = d5 / d3 * (double)n;
            Image image = new SpectrumImageFactory.LinearSpectrumImageFactory().createHorizontalSpectrum(n, n2, d, d2, color, color3);
            PImage pImage = new PImage(image);
            pImage.setOffset(0.0, 0.0);
            this.addChild(pImage);
            if (d6 > 0.0) {
                pText = new PText("UV");
                pText.setTextPaint(color2);
                pText.scale((double)n2 * 0.7 / pText.getFullBounds().getHeight());
                if (d6 > pText.getFullBounds().getWidth()) {
                    this.addChild(pText);
                    pText.setOffset((d6 - pText.getFullBounds().getWidth()) / 2.0, ((double)n2 - pText.getFullBounds().getHeight()) / 2.0);
                }
            }
            if (d7 > 0.0) {
                pText = new PText("IR");
                pText.setTextPaint(color4);
                pText.scale((double)n2 * 0.7 / pText.getFullBounds().getHeight());
                if (d7 > pText.getFullBounds().getWidth()) {
                    this.addChild(pText);
                    pText.setOffset((double)n - d7 + (d7 - pText.getFullBounds().getWidth()) / 2.0, ((double)n2 - pText.getFullBounds().getHeight()) / 2.0);
                }
            }
        }
    }

    private class ValueDisplay
    extends PNode {
        private final JFormattedTextField _formattedTextField;
        private final JLabel _unitsLabel = new JLabel("nm");
        private final PSwing _pswing;

        public ValueDisplay() {
            this._formattedTextField = new JFormattedTextField();
            this._formattedTextField.setColumns(3);
            this._formattedTextField.setHorizontalAlignment(4);
            this._formattedTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WavelengthControl.this.handleTextEntry();
                }
            });
            this._formattedTextField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    ValueDisplay.this._formattedTextField.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    try {
                        ValueDisplay.this._formattedTextField.commitEdit();
                        WavelengthControl.this.handleTextEntry();
                    }
                    catch (ParseException parseException) {
                        WavelengthControl.this.warnUser();
                        ValueDisplay.this.setValue(WavelengthControl.this._wavelength);
                    }
                }
            });
            this._formattedTextField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 38) {
                        if (WavelengthControl.this._wavelength + 1.0 <= WavelengthControl.this._maxWavelength) {
                            WavelengthControl.this.setWavelength(WavelengthControl.this._wavelength + 1.0);
                        } else {
                            WavelengthControl.this.warnUser();
                        }
                    } else if (keyEvent.getKeyCode() == 40) {
                        if (WavelengthControl.this._wavelength - 1.0 >= WavelengthControl.this._minWavelength) {
                            WavelengthControl.this.setWavelength(WavelengthControl.this._wavelength - 1.0);
                        } else {
                            WavelengthControl.this.warnUser();
                        }
                    }
                }
            });
            JPanel jPanel = new JPanel();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            easyGridBagLayout.setInsets(new Insets(0, 3, 0, 0));
            jPanel.setLayout(easyGridBagLayout);
            easyGridBagLayout.setAnchor(17);
            int n = 0;
            int n2 = 0;
            easyGridBagLayout.addComponent(this._formattedTextField, n, n2++);
            easyGridBagLayout.addComponent(this._unitsLabel, n, n2);
            jPanel.setOpaque(false);
            this._unitsLabel.setOpaque(false);
            this._pswing = new PSwing(jPanel);
            this.addChild(this._pswing);
        }

        public void setValue(double d) {
            String string = VALUE_FORMAT.format(d);
            this._formattedTextField.setText(string);
        }

        public double getValue() {
            String string = this._formattedTextField.getText().toLowerCase();
            double d = 0.0;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                WavelengthControl.this.warnUser();
                d = WavelengthControl.this._wavelength;
                this.setValue(d);
            }
            return d;
        }

        public JLabel getUnitsLabel() {
            return this._unitsLabel;
        }

        public JFormattedTextField getFormattedTextField() {
            return this._formattedTextField;
        }

        public void selectAll() {
            this._formattedTextField.selectAll();
        }

        public void computeBounds() {
            this._pswing.updateBounds();
        }
    }
}

