/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.util.Random;

public class ProbabilisticChooser {
    private static final Random RANDOM = new Random();
    private Entry[] _entries;

    public ProbabilisticChooser(Entry[] entryArray) {
        this._entries = new Entry[entryArray.length];
        double d = 0.0;
        for (int i = 0; i < entryArray.length; ++i) {
            d += entryArray[i].getWeight();
        }
        double d2 = 1.0 / d;
        double d3 = 0.0;
        for (int i = 0; i < entryArray.length; ++i) {
            this._entries[i] = new Entry(entryArray[i].getObject(), d3 += entryArray[i].getWeight() * d2);
        }
    }

    public Object get() {
        return this.get(RANDOM.nextDouble());
    }

    public Object get(double d) {
        Object object = null;
        for (int i = 0; i < this._entries.length && object == null; ++i) {
            Entry entry = this._entries[i];
            if (!(d <= entry.getWeight())) continue;
            object = entry.getObject();
        }
        return object;
    }

    public static class Entry {
        private Object object;
        private double weight;

        public Entry(Object object, double d) {
            this.object = object;
            this.weight = d;
        }

        public Object getObject() {
            return this.object;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

