/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.util.regex.Pattern;

public class PolynomialTerm {
    public static final PolynomialTerm ZERO = new PolynomialTerm(0, 0);
    public static final Pattern EXPR_PATTERN = Pattern.compile("([+\\-])? *(\\d+)x\\^(\\d+)");
    private final int power;
    private final int coeff;

    public PolynomialTerm(int n, int n2) {
        this.power = n;
        this.coeff = n2;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
    }

    public int getPower() {
        return this.power;
    }

    public int getCoeff() {
        return this.coeff;
    }

    public PolynomialTerm derive(int n) {
        PolynomialTerm polynomialTerm = this;
        for (int i = 0; i < n; ++i) {
            polynomialTerm = polynomialTerm.derive();
        }
        return polynomialTerm;
    }

    public PolynomialTerm derive() {
        if (this.power == 0) {
            return ZERO;
        }
        return new PolynomialTerm(this.power - 1, this.coeff * this.power);
    }

    public double eval(double d) {
        return Math.pow(d, this.power) * (double)this.coeff;
    }

    public String toString() {
        return this.coeff + "x^" + this.power;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PolynomialTerm polynomialTerm = (PolynomialTerm)object;
        if (this.coeff != polynomialTerm.coeff) {
            return false;
        }
        return this.power == polynomialTerm.power;
    }

    public int hashCode() {
        int n = this.power;
        n = 31 * n + this.coeff;
        return n;
    }
}

