/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo;

import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.expectations.PxValue;
import edu.colorado.phet.quantumwaveinterference.model.expectations.XValue;
import edu.colorado.phet.quantumwaveinterference.model.expectations.YValue;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorMap;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.SimpleWavefunctionGraphic;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;

public class WavefunctionGraphic
extends SimpleWavefunctionGraphic {
    private boolean displayXExpectation;
    private boolean displayYExpectation;
    private boolean displayPyExpectation = false;
    private QWIModel QWIModel;

    public WavefunctionGraphic(QWIModel qWIModel, Wavefunction wavefunction) {
        super(wavefunction);
        this.QWIModel = qWIModel;
    }

    public void setDisplayXExpectation(boolean bl) {
        this.displayXExpectation = bl;
    }

    public void setDisplayYExpectation(boolean bl) {
        this.displayYExpectation = bl;
    }

    protected void decorateBuffer() {
        int n;
        double d;
        BufferedImage bufferedImage = this.getColorGridNode().getBufferedImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.displayXExpectation) {
            d = new XValue().compute(this.getWavefunction());
            n = (int)(d * (double)this.getCellWidth() * (double)this.getWavefunction().getWidth());
            graphics2D.setColor(Color.blue);
            graphics2D.fillRect(n, 0, 2, bufferedImage.getHeight());
        }
        if (this.displayYExpectation) {
            d = new YValue().compute(this.getWavefunction());
            n = (int)(d * (double)this.getCellHeight() * (double)this.getWavefunction().getHeight());
            graphics2D.setColor(Color.blue);
            graphics2D.fillRect(0, n, bufferedImage.getWidth(), 2);
        }
        if (this.displayPyExpectation) {
            d = new PxValue().compute(this.getWavefunction());
            System.out.println("px = " + d);
        }
        graphics2D.dispose();
    }

    private int getCellHeight() {
        return this.getColorGridNode().getCellHeight();
    }

    private int getCellWidth() {
        return this.getColorGridNode().getCellWidth();
    }

    public int getWavefunctionGraphicWidth() {
        return this.getColorGrid().getWidth();
    }

    public void setCellDimensions(Dimension dimension) {
        this.setCellDimensions(dimension.width, dimension.height);
    }

    public void setColorMap(ColorMap colorMap) {
        super.setColorMap(new ColorMapWithPotential(colorMap, this.QWIModel.getPotential()));
    }

    protected void setColorMapIgnorePotential(ColorMap colorMap) {
        super.setColorMap(colorMap);
    }

    static class ColorMapWithPotential
    implements ColorMap {
        private ColorMap delegate;
        private Potential potential;

        public ColorMapWithPotential(ColorMap colorMap, Potential potential) {
            this.delegate = colorMap;
            this.potential = potential;
        }

        public Paint getColor(int n, int n2) {
            if (this.potential.getPotential(n, n2, 0) != 0.0) {
                return Color.red;
            }
            return this.delegate.getColor(n, n2);
        }
    }
}

