/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo;

import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorGrid;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.ComplexColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.ComplexColorMapAdapter;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.MagnitudeColorMap;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.ColorGridNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class SimpleWavefunctionGraphic
extends PNode {
    private ColorGridNode colorGridNode;
    private PPath borderGraphic;
    private Wavefunction wavefunction;
    private ColorMap colorMap;

    public SimpleWavefunctionGraphic(Wavefunction wavefunction) {
        this(wavefunction, 1, 1);
    }

    public SimpleWavefunctionGraphic(Wavefunction wavefunction, int n, int n2) {
        this(wavefunction, n, n2, new ComplexColorMapAdapter(wavefunction, new MagnitudeColorMap()));
    }

    public SimpleWavefunctionGraphic(Wavefunction wavefunction, int n, int n2, ColorMap colorMap) {
        this.wavefunction = wavefunction;
        this.colorGridNode = new ColorGridNode(new ColorGrid(n, n2, wavefunction.getWidth(), wavefunction.getHeight()));
        this.addChild(this.colorGridNode);
        this.colorMap = colorMap;
        this.borderGraphic = new PPath(this.colorGridNode.getFullBounds());
        this.borderGraphic.setStroke(new BasicStroke(2.0f));
        this.borderGraphic.setStrokePaint(Color.white);
        this.addChild(this.borderGraphic);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SimpleWavefunctionGraphic.this.borderGraphic.setPathTo(SimpleWavefunctionGraphic.this.colorGridNode.getFullBounds());
            }
        };
        this.colorGridNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
        this.colorGridNode.addPropertyChangeListener("bounds", propertyChangeListener);
        this.update();
    }

    public void setComplexColorMap(ComplexColorMap complexColorMap) {
        this.setColorMap(new ComplexColorMapAdapter(this.getWavefunction(), complexColorMap));
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
        this.update();
    }

    public void fullPaint(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        super.fullPaint(pPaintContext);
        if (object == null) {
            object = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
        }
        if (object2 == null) {
            object2 = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
    }

    public void update() {
        this.colorGridNode.setGridDimensions(this.wavefunction.getWidth(), this.wavefunction.getHeight());
        this.colorGridNode.paint(this.colorMap);
        this.decorateBuffer();
        this.repaint();
    }

    public ColorGridNode getColorGridNode() {
        return this.colorGridNode;
    }

    protected void decorateBuffer() {
    }

    public Wavefunction getWavefunction() {
        return this.wavefunction;
    }

    public ColorGrid getColorGrid() {
        return this.getColorGridNode().getColorGrid();
    }

    public void setCellDimensions(int n, int n2) {
        this.colorGridNode.setCellDimensions(n, n2);
        this.update();
    }

    public void setGridDimensions(int n, int n2) {
        this.colorGridNode.setGridDimensions(n, n2);
        this.update();
    }
}

