/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.quantumwaveinterference.model.RectangularObject;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorGrid;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class RectangleGraphic
extends PNode {
    private QWIPanel QWIPanel;
    private PPath areaGraphic;
    private PPath resizeCorner;
    private RectangularObject rectangularObject;

    public RectangleGraphic(QWIPanel qWIPanel, final RectangularObject rectangularObject, Color color) {
        this.QWIPanel = qWIPanel;
        this.rectangularObject = rectangularObject;
        this.areaGraphic = new PPath();
        this.areaGraphic.setStrokePaint(Color.blue);
        this.areaGraphic.setStroke(new BasicStroke(2.0f));
        this.areaGraphic.setPaint(color);
        this.addChild(this.areaGraphic);
        this.areaGraphic.addInputEventListener(new ContinuousDrag(new LocationGetter(){

            public Point getLocation() {
                return rectangularObject.getLocation();
            }
        }));
        this.areaGraphic.addInputEventListener(new CursorHandler(12));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 10.0f);
        generalPath.lineTo(10.0f, 10.0f);
        generalPath.lineTo(10.0f, 0.0f);
        this.resizeCorner = new PPath(generalPath);
        this.resizeCorner.setStroke(new BasicStroke(4.0f));
        this.resizeCorner.setStrokePaint(Color.green);
        this.resizeCorner.addInputEventListener(new CornerDrag());
        this.resizeCorner.addInputEventListener(new CursorHandler(5));
        this.addChild(this.resizeCorner);
        rectangularObject.addObserver(new SimpleObserver(){

            public void update() {
                RectangleGraphic.this.update();
            }
        });
        this.update();
        this.getColorGrid().addListener(new ColorGrid.Listener(){

            public void update() {
                RectangleGraphic.this.update();
            }
        });
        this.QWIPanel.getWavefunctionGraphic().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RectangleGraphic.this.update();
            }
        });
    }

    protected void disableResizeCorner() {
        this.resizeCorner.setVisible(false);
        this.resizeCorner.setPickable(false);
        this.resizeCorner.setChildrenPickable(false);
    }

    protected void disableBodyGraphic() {
        this.areaGraphic.setVisible(false);
        this.areaGraphic.setPickable(false);
        this.areaGraphic.setChildrenPickable(false);
    }

    public void setResizeComponentVisible(boolean bl) {
        this.resizeCorner.setVisible(bl);
    }

    protected void update() {
        Rectangle rectangle = this.rectangularObject.getBounds();
        Rectangle rectangle2 = this.getViewRectangle(rectangle);
        this.areaGraphic.setPathTo(rectangle2);
        this.resizeCorner.setOffset((double)((int)rectangle2.getMaxX()) - this.resizeCorner.getWidth() + 4.0, (double)((int)rectangle2.getMaxY()) - this.resizeCorner.getHeight() + 4.0);
    }

    protected ColorGrid getColorGrid() {
        return this.QWIPanel.getWavefunctionGraphic().getColorGrid();
    }

    public PPath getAreaGraphic() {
        return this.areaGraphic;
    }

    public Rectangle getViewRectangle(Rectangle rectangle) {
        Rectangle rectangle2 = this.getColorGrid().getViewRectangle(rectangle);
        if (rectangle2.width == 0) {
            rectangle2.width = 1;
        }
        if (rectangle2.height == 0) {
            rectangle2.height = 1;
        }
        this.getSchrodingerPanel().getWavefunctionGraphic().localToGlobal(rectangle2);
        this.globalToLocal(rectangle2);
        this.localToParent(rectangle2);
        return rectangle2;
    }

    public QWIPanel getSchrodingerPanel() {
        return this.QWIPanel;
    }

    public class ContinuousDrag
    extends PBasicInputEventHandler {
        Point2D startLocation;
        Point origLoc;
        LocationGetter locationGetter;

        public ContinuousDrag(LocationGetter locationGetter) {
            this.locationGetter = locationGetter;
        }

        public void mousePressed(PInputEvent pInputEvent) {
            this.startLocation = new Point2D.Double(pInputEvent.getPosition().getX(), pInputEvent.getPosition().getY());
            this.origLoc = this.locationGetter.getLocation();
        }

        public void mouseReleased(PInputEvent pInputEvent) {
            this.startLocation = null;
            this.origLoc = null;
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            if (this.startLocation == null) {
                this.mousePressed(pInputEvent);
            } else {
                Point2D point2D = pInputEvent.getPosition();
                Point2D.Double double_ = new Point2D.Double(point2D.getX() - this.startLocation.getX(), point2D.getY() - this.startLocation.getY());
                double d = double_.x;
                double d2 = double_.y;
                int n = (int)(d / (double)RectangleGraphic.this.getColorGrid().getCellWidth());
                int n2 = (int)(d2 / (double)RectangleGraphic.this.getColorGrid().getCellHeight());
                RectangleGraphic.this.rectangularObject.setLocation(n + this.origLoc.x, n2 + this.origLoc.y);
            }
        }
    }

    public class CornerDrag
    extends PBasicInputEventHandler {
        Point2D.Double startLocation;
        Dimension origDim;

        public void mousePressed(PInputEvent pInputEvent) {
            this.startLocation = new Point2D.Double(pInputEvent.getPosition().getX(), pInputEvent.getPosition().getY());
            this.origDim = RectangleGraphic.this.rectangularObject.getDimension();
        }

        public void mouseReleased(PInputEvent pInputEvent) {
            this.startLocation = null;
            this.origDim = null;
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            if (this.startLocation == null) {
                this.mousePressed(pInputEvent);
            } else {
                Point2D point2D = pInputEvent.getPosition();
                Point2D.Double double_ = new Point2D.Double(point2D.getX() - this.startLocation.x, point2D.getY() - this.startLocation.y);
                double d = double_.x;
                double d2 = double_.y;
                int n = (int)(d / (double)RectangleGraphic.this.getColorGrid().getCellWidth());
                int n2 = (int)(d2 / (double)RectangleGraphic.this.getColorGrid().getCellHeight());
                int n3 = this.origDim.width + n;
                int n4 = this.origDim.height + n2;
                n3 = Math.max(n3, 0);
                n4 = Math.max(n4, 0);
                RectangleGraphic.this.rectangularObject.setSize(n3, n4);
            }
        }
    }

    private static interface LocationGetter {
        public Point getLocation();
    }
}

