/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo;

import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.quantumwaveinterference.model.potentials.RectangularPotential;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.RectangularPotentialGraphic;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Rectangle;

public class ImagePotentialGraphic
extends RectangularPotentialGraphic {
    private PImage image = PImageFactory.create("quantum-wave-interference/images/atom3.gif");
    private int origWidth;

    public ImagePotentialGraphic(QWIPanel qWIPanel, RectangularPotential rectangularPotential) {
        super(qWIPanel, rectangularPotential);
        this.addChild(this.image);
        this.origWidth = this.image.getImage().getWidth(null);
        this.disableCloseGraphic();
        this.disablePotentialDisplayGraphic();
        this.disableResizeCorner();
        this.disableBodyGraphic();
        this.update();
    }

    protected void update() {
        super.update();
        if (super.getPotential() != null && this.image != null) {
            Rectangle rectangle = this.getPotential().getBounds();
            Rectangle rectangle2 = super.getViewRectangle(rectangle);
            if (rectangle2.width == 0) {
                return;
            }
            this.image.setScale((double)rectangle2.width / (double)this.origWidth);
            this.image.setOffset(rectangle2.x, rectangle2.y);
        }
    }
}

