/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.quantumwaveinterference.QWILookAndFeel;
import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.RectangleGraphic;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;

public class DetectorGraphic
extends RectangleGraphic {
    private Detector detector;
    private DecimalFormat format = new DecimalFormat("0.00");
    private PText probDisplay;
    private PSwing closeGraphic;
    private Color darkGreen;
    private static Color fill = new Color(200, 180, 150, 0);
    private boolean probDisplayAllowedToBeVisible = true;
    private QWIPanel qwiPanel;
    private Color enabledStrokeColor = new Color(0, 185, 255);

    public DetectorGraphic(final QWIPanel qWIPanel, Detector detector) {
        super(qWIPanel, detector, fill);
        this.qwiPanel = qWIPanel;
        this.detector = detector;
        this.darkGreen = new Color(50, 230, 75);
        this.probDisplay = new PText();
        this.probDisplay.setFont(new PhetFont(1, 14));
        this.probDisplay.setTextPaint(this.darkGreen);
        this.probDisplay.setPickable(false);
        this.probDisplay.setChildrenPickable(false);
        this.addChild(this.probDisplay);
        detector.addObserver(new SimpleObserver(){

            public void update() {
                DetectorGraphic.this.updateDetectorReadouts();
                DetectorGraphic.this.update();
            }
        });
        JButton jButton = QWILookAndFeel.createCloseButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                qWIPanel.removeDetectorGraphic(DetectorGraphic.this);
            }
        });
        this.closeGraphic = new PSwing(jButton);
        this.addChild(this.closeGraphic);
        this.updateDetectorReadouts();
        this.update();
    }

    private void updateDetectorReadouts() {
        this.qwiPanel.updateDetectorReadouts();
    }

    public void setCloseButtonVisible(boolean bl) {
        this.closeGraphic.setVisible(bl);
    }

    public void setPercentDisplayVisible(boolean bl) {
        this.probDisplayAllowedToBeVisible = bl;
        this.probDisplay.setVisible(bl);
    }

    protected Rectangle getViewRectangle() {
        return super.getViewRectangle(this.detector.getBounds());
    }

    protected void update() {
        super.update();
        if (this.probDisplay != null) {
            String string = this.format.format(this.detector.getProbability() * 100.0);
            this.probDisplay.setText(string + " %");
            this.probDisplay.setOffset(this.getViewRectangle().x, this.getViewRectangle().y);
            this.probDisplay.setVisible(this.detector.isEnabled() && this.probDisplayAllowedToBeVisible);
            this.getAreaGraphic().setStrokePaint(this.detector.isEnabled() ? this.enabledStrokeColor : Color.gray);
            this.closeGraphic.setOffset((int)((double)this.getViewRectangle().x - this.closeGraphic.getWidth()), (double)this.getViewRectangle().y - this.closeGraphic.getHeight());
        }
    }

    public Detector getDetector() {
        return this.detector;
    }
}

