/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.quantumwaveinterference.controls.ResolutionControl;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.PhotonBeam;

public class PhotonBeamParticle
extends GunParticle {
    private PhotonBeam photonBeam;
    private ModelElement rampUp;
    private ModelElement rampDown;
    private Pauser pauser;

    public PhotonBeamParticle(AbstractGunNode abstractGunNode, String string, PhotonBeam photonBeam) {
        super(abstractGunNode, string, photonBeam.getImageLocation());
        this.photonBeam = photonBeam;
        this.rampUp = new RampUp();
        this.rampDown = new RampDown();
        this.pauser = new Pauser();
        photonBeam.getPhoton().removeMomentumChangeListener(photonBeam.getColorChangeHandler());
    }

    private double getFinalNormValue() {
        return 0.995 * this.getWaveValueScale();
    }

    private double getWaveValueScale() {
        double d = this.getWaveArea() / this.getDefaultArea();
        return d * d;
    }

    double getDefaultArea() {
        return ResolutionControl.INIT_WAVE_SIZE * ResolutionControl.INIT_WAVE_SIZE;
    }

    double getWaveArea() {
        return this.getDiscreteModel().getGridHeight() * this.getDiscreteModel().getGridWidth();
    }

    private double getRampDownPeak() {
        return 0.98 * this.getWaveValueScale();
    }

    private double getRampUpPeak() {
        return 0.4 * this.getWaveValueScale();
    }

    public void reset() {
        this.photonBeam.setIntensity(0.0);
        this.photonBeam.setHighIntensityModeOn(false);
        this.clearModelElements();
        this.pauser.reset();
    }

    private void removeModelElement(ModelElement modelElement) {
        this.getSchrodingerModule().getModel().removeModelElement(modelElement);
    }

    private void addModelElement(ModelElement modelElement) {
        this.getSchrodingerModule().getModel().addModelElement(modelElement);
    }

    public void fireParticle() {
        this.getGunGraphic().getSchrodingerPanel().setPhoton(this.photonBeam.getPhoton());
        this.clearModelElements();
        this.photonBeam.setHighIntensityModeOn(true);
        this.photonBeam.setIntensity(0.0);
        this.addModelElement(this.rampUp);
    }

    public boolean isFiring() {
        return this.containsModelElement(this.rampUp) || this.containsModelElement(this.rampDown) || this.containsModelElement(this.pauser);
    }

    public double getMinimumProbabilityForDetection() {
        return 0.05;
    }

    public boolean getTimeThresholdAllowed() {
        return true;
    }

    public int getTimeThresholdCount() {
        return 30;
    }

    private boolean containsModelElement(ModelElement modelElement) {
        return this.getSchrodingerModule().getModel().containsModelElement(modelElement);
    }

    private void clearModelElements() {
        this.removeModelElement(this.rampUp);
        this.removeModelElement(this.rampDown);
        this.removeModelElement(this.pauser);
    }

    public void activate(AbstractGunNode abstractGunNode) {
        this.active = true;
        this.photonBeam.getPhoton().activate(abstractGunNode);
    }

    public void deactivate(AbstractGunNode abstractGunNode) {
        this.active = false;
        this.photonBeam.getPhoton().deactivate(abstractGunNode);
        this.getGunGraphic().getSchrodingerPanel().setPhoton(null);
    }

    public double getStartPy() {
        return this.photonBeam.getPhoton().getStartPy();
    }

    protected double getHBar() {
        return 1.0;
    }

    protected void detachListener(GunParticle.ChangeHandler changeHandler) {
        this.photonBeam.getPhoton().detachListener(changeHandler);
    }

    protected void hookupListener(GunParticle.ChangeHandler changeHandler) {
        this.photonBeam.getPhoton().hookupListener(changeHandler);
    }

    abstract class AbstractBeamAdder
    implements ModelElement {
        AbstractBeamAdder() {
        }

        public void stepInTime(double d) {
            PhotonBeamParticle.this.getDiscreteModel().getWavefunction().setMagnitudeDirty();
            double d2 = PhotonBeamParticle.this.getDiscreteModel().getWavefunction().getMagnitude();
            double d3 = PhotonBeamParticle.this.photonBeam.getIntensity();
            if (d2 > PhotonBeamParticle.this.getRampUpPeak() && this instanceof RampUp) {
                PhotonBeamParticle.this.removeModelElement(this);
                PhotonBeamParticle.this.addModelElement(PhotonBeamParticle.this.rampDown);
            }
            d3 += this.getIncrement();
            d3 = Math.max(d3, 0.0);
            PhotonBeamParticle.this.photonBeam.setIntensity(d3);
            if (d2 > PhotonBeamParticle.this.getRampDownPeak() || this instanceof RampDown && d3 == 0.0) {
                PhotonBeamParticle.this.getDiscreteModel().setWavefunctionNorm(PhotonBeamParticle.this.getFinalNormValue());
                PhotonBeamParticle.this.removeModelElement(this);
                PhotonBeamParticle.this.addModelElement(PhotonBeamParticle.this.pauser);
                PhotonBeamParticle.this.photonBeam.setIntensity(0.0);
                PhotonBeamParticle.this.getGunGraphic().notifyGunFired();
            }
        }

        abstract double getIncrement();
    }

    class Pauser
    implements ModelElement {
        int count = 0;
        int maxCount = 20;

        Pauser() {
        }

        public void stepInTime(double d) {
            ++this.count;
            PhotonBeamParticle.this.getDiscreteModel().setWavefunctionNorm(PhotonBeamParticle.this.getFinalNormValue());
            if (this.count >= this.maxCount) {
                while (PhotonBeamParticle.this.getSchrodingerModule().getModel().containsModelElement(this)) {
                    PhotonBeamParticle.this.removeModelElement(this);
                }
                PhotonBeamParticle.this.photonBeam.setIntensity(0.0);
                PhotonBeamParticle.this.photonBeam.setHighIntensityModeOn(false);
                this.count = 0;
            }
        }

        public void reset() {
            this.count = 0;
        }
    }

    class RampDown
    extends AbstractBeamAdder {
        RampDown() {
        }

        double getIncrement() {
            return -0.05;
        }
    }

    class RampUp
    extends AbstractBeamAdder {
        RampUp() {
        }

        double getIncrement() {
            return 0.05;
        }
    }
}

