/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.quantumwaveinterference.view.gun.SingleParticleGunNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.IntensityManager;

public class AutoFire
implements IntensityManager.Listener {
    private SingleParticleGunNode gunGraphic;
    private IntensityManager intensityManager;
    private boolean autoFire = false;
    private ModelElement element;
    private long lastFire = 0L;
    int count = 0;

    public AutoFire(SingleParticleGunNode singleParticleGunNode, IntensityManager intensityManager) {
        this.gunGraphic = singleParticleGunNode;
        this.intensityManager = intensityManager;
        intensityManager.addListener(this);
        this.element = new ModelElement(){

            public void stepInTime(double d) {
                AutoFire.this.checkDetection();
            }
        };
    }

    private void checkDetection() {
        ++this.count;
        if (this.count > 400) {
            this.fire();
        } else {
            double d = this.gunGraphic.getSchrodingerModule().getQWIModel().getWavefunction().getMagnitude();
            if ((d < 0.04 || Double.isNaN(d)) && this.timeSinceFire() > 500L && !this.gunGraphic.isFiring()) {
                this.fire();
            }
        }
    }

    private long timeSinceFire() {
        return System.currentTimeMillis() - this.lastFire;
    }

    private void fire() {
        this.gunGraphic.clearAndFire();
        this.lastFire = System.currentTimeMillis();
        this.count = 0;
    }

    public void detectionOccurred() {
        if (this.autoFire) {
            this.fire();
        }
    }

    public void setAutoFire(boolean bl) {
        if (this.autoFire != bl) {
            this.autoFire = bl;
            if (this.autoFire) {
                if (this.intensityManager.getSchrodingerPanel().getDiscreteModel().getWavefunction().getMagnitude() == 0.0) {
                    this.fire();
                }
                this.gunGraphic.getSchrodingerModule().getModel().addModelElement(this.element);
            } else {
                this.gunGraphic.getSchrodingerModule().getModel().removeModelElement(this.element);
            }
        }
    }
}

