/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.complexcolormaps;

import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.ComplexColorMap;
import java.awt.Color;
import java.awt.Paint;

public abstract class GrayscaleColorMap
implements ComplexColorMap {
    private double colorScale;

    public GrayscaleColorMap() {
        this(12.0);
    }

    public GrayscaleColorMap(double d) {
        this.colorScale = d;
    }

    public Paint getColor(Complex complex) {
        double d = this.getComponent(complex);
        if ((d = Math.abs(d)) > 1.0) {
            System.out.println("re = " + d);
            d = 1.0;
        }
        Color color = new Color((float)d, (float)d, (float)d);
        color = this.scaleUp(color);
        return color;
    }

    protected abstract double getComponent(Complex var1);

    private Color scaleUp(Color color) {
        return new Color(this.scaleUp(color.getRed()), this.scaleUp(color.getGreen()), this.scaleUp(color.getBlue()));
    }

    private float scaleUp(int n) {
        float f = (float)n / 255.0f;
        if ((f = (float)((double)f * this.colorScale)) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static class Imaginary
    extends GrayscaleColorMap {
        protected double getComponent(Complex complex) {
            return complex.getImaginary();
        }
    }

    public static class Real
    extends GrayscaleColorMap {
        protected double getComponent(Complex complex) {
            return complex.getReal();
        }
    }
}

