/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.phetcommon;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ImageComboBox
extends JComboBox {
    public static ImageIcon[] toLabelArray(Item[] itemArray) {
        ImageIcon[] imageIconArray = new ImageIcon[itemArray.length];
        for (int i = 0; i < imageIconArray.length; ++i) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageLoader.loadBufferedImage(itemArray[i].getImageLocation());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bufferedImage == null) {
                bufferedImage = new BufferedImage(5, 5, 1);
            }
            imageIconArray[i] = new ImageIcon(bufferedImage);
            imageIconArray[i].setDescription(itemArray[i].getLabel());
        }
        return imageIconArray;
    }

    public static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            ImageIcon imageIcon = (ImageIcon)object;
            if (imageIcon != null) {
                this.setText(imageIcon.getDescription());
            }
            this.setIcon(imageIcon);
            return this;
        }
    }

    public static class Item {
        String label;
        String imageLocation;

        public Item(String string, String string2) {
            this.label = string;
            this.imageLocation = string2;
        }

        public String getLabel() {
            return this.label;
        }

        public String getImageLocation() {
            return this.imageLocation;
        }
    }
}

