/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.single;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.QuantumWaveInterferenceApplication;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.WaveModel;
import edu.colorado.phet.quantumwaveinterference.modules.single.SingleParticleClockControlPanel;
import edu.colorado.phet.quantumwaveinterference.modules.single.SingleParticleControlPanel;
import edu.colorado.phet.quantumwaveinterference.modules.single.SingleParticleSchrodingerPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.SingleParticleGunNode;

public class SingleParticleModule
extends QWIModule {
    public SingleParticleSchrodingerPanel schrodingerSchrodingerPanel;
    int count;

    public SingleParticleModule(QuantumWaveInterferenceApplication quantumWaveInterferenceApplication, IClock iClock) {
        super(QWIResources.getString("module.single-particles"), quantumWaveInterferenceApplication, iClock);
        this.setQWIModel(new QWIModel());
        this.schrodingerSchrodingerPanel = new SingleParticleSchrodingerPanel(this);
        this.setSchrodingerPanel(this.schrodingerSchrodingerPanel);
        this.setSchrodingerControlPanel(new SingleParticleControlPanel(this));
        this.getSchrodingerPanel().getDetectorSheetPNode().getDetectorSheetControlPanel().setTypeControlVisible(false);
        this.getSchrodingerPanel().getDetectorSheetPNode().updatePSwing();
        this.getSingleParticleGunNode().addSingleParticleGunNodeListener(new SingleParticleGunNode.SingleParticleGunNodeListener(){

            public void gunParticleTypeChanged() {
                SingleParticleModule.this.updateDetectionThresholds();
            }
        });
        this.getSchrodingerPanel().setFadeEnabled(true);
        this.updateDetectionThresholds();
        this.setClockControlPanel(new SingleParticleClockControlPanel(this, iClock));
        this.getSingleParticleGunNode().addListener(new AbstractGunNode.Listener(){

            public void gunFired() {
                SingleParticleModule.this.count = 0;
            }
        });
        this.addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                ++SingleParticleModule.this.count;
                if (SingleParticleModule.this.count > 100) {
                    SingleParticleModule.this.reduceWavefunction();
                }
            }
        });
        this.finishInit();
    }

    private void reduceWavefunction() {
        WaveModel waveModel = this.getQWIModel().getWaveModel();
        double d = waveModel.getWavefunction().getMagnitude();
        double d2 = Math.max(d - 0.01, 0.0) * 0.9;
        waveModel.setMagnitude(d2);
    }

    private void updateDetectionThresholds() {
        this.setMinimumProbabilityForDetection(this.getSingleParticleGunNode().getGunParticle().getMinimumProbabilityForDetection());
        this.setTimeThreshold(this.getSingleParticleGunNode().getGunParticle().getTimeThresholdAllowed());
        this.setTimeThresholdCount(this.getSingleParticleGunNode().getGunParticle().getTimeThresholdCount());
    }

    private SingleParticleGunNode getSingleParticleGunNode() {
        return this.schrodingerSchrodingerPanel.getSingleParticleGunNode();
    }

    public void setRapid(boolean bl) {
        SwingClock swingClock = (SwingClock)this.getClock();
        swingClock.setDelay(bl ? 0 : 30);
    }
}

