/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.mandel;

import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelModule;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorMap;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.WaveValueAccessor;
import java.awt.Color;
import java.awt.Paint;

public class MandelSplitColorMap
implements ColorMap {
    private MiniPhotonColorMap leftColorMapMini;
    private MiniPhotonColorMap rightColorMapMini;
    private WaveValueAccessor waveValueAccessor;

    public MandelSplitColorMap(MandelModule mandelModule, WaveValueAccessor waveValueAccessor) {
        this.waveValueAccessor = waveValueAccessor;
        this.leftColorMapMini = new MiniPhotonColorMap(mandelModule.getMandelSchrodingerPanel().getLeftGun().getWavelength(), this.waveValueAccessor, mandelModule.getMandelModel().getLeftWaveModel().getWavefunction());
        this.rightColorMapMini = new MiniPhotonColorMap(mandelModule.getMandelSchrodingerPanel().getRightGun().getWavelength(), this.waveValueAccessor, mandelModule.getMandelModel().getRightWaveModel().getWavefunction());
    }

    public static Color add(Color color, Color color2) {
        return new Color(Math.min(color.getRed() + color2.getRed(), 255), Math.min(color.getGreen() + color2.getGreen(), 255), Math.min(color.getBlue() + color2.getBlue(), 255));
    }

    public Paint getColor(int n, int n2) {
        Color color = (Color)this.leftColorMapMini.getColor(n, n2);
        Color color2 = (Color)this.rightColorMapMini.getColor(n, n2);
        return MandelSplitColorMap.add(color, color2);
    }

    public static class MiniPhotonColorMap
    implements ColorMap {
        private WaveValueAccessor waveValueAccessor;
        private double intensityScale = 20.0;
        private ColorData rootColor;
        private Wavefunction wave;

        public MiniPhotonColorMap(double d, WaveValueAccessor waveValueAccessor, Wavefunction wavefunction) {
            this.wave = wavefunction;
            if (waveValueAccessor == null) {
                throw new RuntimeException("Null waveValueAccessor");
            }
            this.waveValueAccessor = waveValueAccessor;
            this.rootColor = new ColorData(d);
        }

        public Paint getColor(int n, int n2) {
            double d = Math.min(this.waveValueAccessor.getValue(this.wave, n, n2) * this.intensityScale, 1.0);
            return this.rootColor.toColor(d);
        }
    }
}

