/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.intensity;

import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityModule;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorMap;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.SplitColorMap;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.WaveValueAccessor;
import edu.colorado.phet.quantumwaveinterference.view.gun.IntensityGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.Photon;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.ContinuousDisplay;
import edu.umd.cs.piccolox.pswing.PSwing;

public class IntensityBeamPanel
extends QWIPanel {
    private QWIModule intensityModule;
    private ContinuousDisplay continuousDisplay;
    private SplitColorMap splitColorMap;
    private IntensityGunNode intensityGun;
    private boolean splitMode = false;
    private boolean continuousMode = false;

    public IntensityBeamPanel(QWIModule qWIModule) {
        super(qWIModule);
        this.intensityModule = qWIModule;
        this.intensityGun = this.createGun();
        this.setGunGraphic(this.intensityGun);
        this.addGunChooserGraphic();
        this.doAddGunControlPanel();
        this.getIntensityDisplay().setHighIntensityMode();
        this.continuousDisplay = new ContinuousDisplay(this, this.getIntensityDisplay());
        this.setContinuousMode(true);
        if (qWIModule instanceof IntensityModule) {
            this.splitColorMap = new SplitColorMap(((IntensityModule)qWIModule).getSplitModel(), this);
        }
        super.update();
        this.setPhoton(super.getDisplayPhotonColor());
        this.getDetectorSheetPNode().getDetectorSheetControlPanel().setBrightness();
        qWIModule.addListener(new QWIModule.Listener(){

            public void deactivated() {
            }

            public void activated() {
            }

            public void beamTypeChanged() {
                IntensityBeamPanel.this.updateWavefunctionColorMap();
                IntensityBeamPanel.this.setSplitMode(IntensityBeamPanel.this.splitMode);
            }
        });
    }

    private WaveValueAccessor getWaveValueAccessorForSplit() {
        if (this.isPhotonMode() && this.getWaveValueAccessor() instanceof WaveValueAccessor.Imag) {
            return new WaveValueAccessor.Empty();
        }
        return this.getWaveValueAccessor();
    }

    protected void doAddGunControlPanel() {
        super.addGunControlPanel();
    }

    protected void addGunChooserGraphic() {
        if (this.useGunChooserGraphic()) {
            PSwing pSwing = new PSwing(this.intensityGun.getComboBox());
            this.intensityGun.getComboBox().setEnvironment(pSwing, this);
            this.getSchrodingerScreenNode().setGunTypeChooserGraphic(pSwing);
        }
    }

    public IntensityGunNode getHighIntensityGun() {
        return this.intensityGun;
    }

    protected boolean useGunChooserGraphic() {
        return true;
    }

    protected IntensityGunNode createGun() {
        return new IntensityGunNode(this);
    }

    public void setSplitMode(boolean bl) {
        this.splitMode = bl;
        super.update();
    }

    protected ColorMap createColorMap() {
        if (this.splitColorMap != null) {
            this.splitColorMap.setWaveValueAccessor(this.getWaveValueAccessorForSplit());
        }
        if (this.splitMode) {
            return this.splitColorMap;
        }
        return super.createColorMap();
    }

    public void setContinuousMode(boolean bl) {
        if (bl != this.continuousMode) {
            this.continuousMode = bl;
            this.getDetectorSheetPNode().clearScreen();
            if (bl) {
                this.getDetectorSheetPNode().setSaveButtonVisible(true);
            }
        }
    }

    protected void updateScreen() {
        if (this.continuousMode) {
            this.continuousDisplay.updateValues();
        } else {
            this.getIntensityDisplay().tryDetecting();
        }
    }

    public boolean isContinuousMode() {
        return this.continuousMode;
    }

    public ContinuousDisplay getContinuousDisplay() {
        return this.continuousDisplay;
    }

    public void setPhoton(Photon photon) {
        super.setPhoton(photon);
        if (this.splitColorMap != null) {
            this.splitColorMap.setRootColor(photon == null ? null : new ColorData(photon.getWavelengthNM()));
        }
        if (this.continuousDisplay != null) {
            this.continuousDisplay.setPhotonColor(photon == null ? null : photon.getRootColor());
        }
    }

    public ColorData getRootColor() {
        return this.intensityGun.getRootColor();
    }

    public void setWaveSize(int n, int n2) {
        super.setWaveSize(n, n2);
        this.intensityGun.setOn(this.intensityGun.isOn());
    }
}

