/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.waves;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;

public class PlaneWave2D
implements Wave {
    private ImmutableVector2D k;
    private double gridDim;
    private double scale = 1.0;
    private double phase = 0.0;
    private double dPhase;

    public PlaneWave2D(ImmutableVector2D immutableVector2D, double d) {
        this.k = immutableVector2D;
        this.gridDim = d;
    }

    public Complex getValue(int n, int n2, double d) {
        Vector2D vector2D = new Vector2D(n, n2);
        double d2 = this.k.dot(vector2D);
        double d3 = 1.0 / this.k.getMagnitude();
        this.phase = 0.0 + this.dPhase;
        Complex complex = new Complex(Math.cos(d2 / this.gridDim - d3 * d + this.phase), Math.sin(d2 / this.gridDim - d3 * d + this.phase));
        complex.scale(this.scale);
        return complex;
    }

    public void setPhase(double d) {
        this.phase = d;
    }

    public void setPhaseOffset(double d) {
        this.dPhase = d;
    }
}

