/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.waves;

import edu.colorado.phet.quantumwaveinterference.model.math.Complex;

public class GaussianWave1D {
    private double momentum;
    private double x0;
    private double dxLattice;
    private double hbar;

    public GaussianWave1D(double d, double d2, double d3, double d4) {
        this.momentum = d;
        this.x0 = d2;
        this.dxLattice = d3;
        this.hbar = d4;
    }

    public Complex getValue(double d) {
        double d2 = Math.pow(Math.PI * this.dxLattice * this.dxLattice, -0.25);
        double d3 = Math.exp(-(d - this.x0) * (d - this.x0) / 2.0 / this.dxLattice / this.dxLattice);
        Complex complex = Complex.exponentiateImaginary(this.momentum * (d - this.x0) / this.hbar);
        complex.scale(d2 * d3);
        return complex;
    }
}

