/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.propagators;

import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import edu.colorado.phet.quantumwaveinterference.model.propagators.RichardsonPropagator;

public class ModifiedRichardsonPropagator
extends RichardsonPropagator {
    public ModifiedRichardsonPropagator(double d, Potential potential, double d2, double d3) {
        super(d, potential, d2, d3);
    }

    protected Complex createAlpha() {
        double d = super.getEpsilon();
        return new Complex(0.5 + 0.5 * Math.cos(d / 2.0), -0.5 * Math.sin(d / 2.0));
    }

    protected Complex createBeta() {
        double d = super.getEpsilon();
        return new Complex(Math.sin(d / 4.0) * Math.sin(d / 4.0), 0.5 * Math.sin(d / 2.0));
    }

    protected void prop2D(Wavefunction wavefunction) {
        if (this.copy == null) {
            this.copy = new Wavefunction(wavefunction.getWidth(), wavefunction.getHeight());
        }
        this.stepIt(wavefunction, 0, -1);
        this.stepIt(wavefunction, 0, 1);
        this.stepIt(wavefunction, 1, 0);
        this.stepIt(wavefunction, -1, 0);
        this.applyPotential(wavefunction);
        this.stepIt(wavefunction, -1, 0);
        this.stepIt(wavefunction, 1, 0);
        this.stepIt(wavefunction, 0, -1);
        this.stepIt(wavefunction, 0, 1);
    }

    public Propagator copy() {
        return new ModifiedRichardsonPropagator(this.getDeltaTime(), super.getPotential(), this.getHBar(), this.getMass());
    }
}

