/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.potentials;

import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.potentials.BarrierPotential;
import edu.colorado.phet.quantumwaveinterference.model.potentials.CompositePotential;
import edu.colorado.phet.quantumwaveinterference.model.potentials.PrecomputedPotential;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;

public class HorizontalDoubleSlit
implements Potential {
    private int gridWidth;
    private int gridHeight;
    private int y;
    private int height;
    private int slitWidth;
    private int numCellsBetweenSlits;
    private double potential;
    private Potential potentialDelegate;
    private Rectangle leftSlit;
    private Rectangle rightSlit;
    private ArrayList listeners = new ArrayList();
    private boolean inverse = false;

    public HorizontalDoubleSlit(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        this.gridWidth = n;
        this.gridHeight = n2;
        this.y = n3;
        this.height = n4;
        this.slitWidth = n5;
        this.numCellsBetweenSlits = n6;
        this.potential = d;
        this.update();
    }

    public String toString() {
        return "gridWidth=" + this.gridWidth + ", gridHeight=" + this.gridHeight + ", y=" + this.y + ", height=" + this.height + ", slitSize=" + this.slitWidth + ", slitsep=" + this.numCellsBetweenSlits;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void update() {
        if (this.gridWidth % 2 == 0) {
            this.updateEven();
        } else {
            this.updateOdd();
        }
    }

    private void updateOdd() {
        int n = (this.gridWidth - 1) / 2;
        int n2 = this.numCellsBetweenSlits / 2;
        int n3 = n - n2 - this.slitWidth;
        int n4 = n + n2 + 1;
        this.leftSlit = new Rectangle(n3, this.y, this.slitWidth, this.height);
        this.rightSlit = new Rectangle(n4, this.y, this.slitWidth, this.height);
        this.updatePotentialDelegate();
        this.notifyListeners();
    }

    private void updateEven() {
        int n = (this.gridWidth - 1) / 2;
        int n2 = this.numCellsBetweenSlits / 2 - 1;
        int n3 = n - n2 - this.slitWidth;
        int n4 = n + n2 + 2;
        this.leftSlit = new Rectangle(n3, this.y, this.slitWidth, this.height);
        this.rightSlit = new Rectangle(n4, this.y, this.slitWidth, this.height);
        this.updatePotentialDelegate();
        this.notifyListeners();
    }

    private void updatePotentialDelegate() {
        Rectangle[] rectangleArray = this.toBars();
        CompositePotential compositePotential = new CompositePotential();
        if (this.inverse) {
            compositePotential.addPotential(new BarrierPotential(this.leftSlit, this.potential));
            compositePotential.addPotential(new BarrierPotential(this.rightSlit, this.potential));
        } else {
            compositePotential.addPotential(new BarrierPotential(rectangleArray[0], this.potential));
            compositePotential.addPotential(new BarrierPotential(rectangleArray[1], this.potential));
            compositePotential.addPotential(new BarrierPotential(rectangleArray[2], this.potential));
        }
        this.potentialDelegate = new PrecomputedPotential(compositePotential, this.gridWidth, this.gridHeight);
    }

    private Rectangle[] toBars() {
        return new Rectangle[]{new Rectangle(0, this.y, this.leftSlit.x, this.height), new Rectangle(this.leftSlit.x + this.leftSlit.width, this.y, this.rightSlit.x - this.leftSlit.x - this.leftSlit.width, this.height), new Rectangle(this.rightSlit.x + this.rightSlit.width, this.y, this.leftSlit.x, this.height)};
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.slitChanged();
        }
    }

    public void setGridWidth(int n) {
        this.gridWidth = n;
        this.update();
    }

    public void setGridHeight(int n) {
        this.gridHeight = n;
        this.update();
    }

    public void setY(int n) {
        this.y = n;
        this.update();
    }

    public void setHeight(int n) {
        this.height = n;
        this.update();
    }

    public void setSlitWidth(int n) {
        this.slitWidth = n;
        this.update();
    }

    public void setNumCellsBetweenSlits(int n) {
        this.numCellsBetweenSlits = n;
        this.update();
    }

    public double getPotential(int n, int n2, int n3) {
        return this.potentialDelegate.getPotential(n, n2, n3);
    }

    public int getY() {
        return this.y;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle[] getSlitAreas() {
        return new Rectangle[]{new Rectangle(this.leftSlit), new Rectangle(this.rightSlit)};
    }

    public Rectangle[] getBlockAreas() {
        return this.toBars();
    }

    public void setInverseSlits(boolean bl) {
        this.inverse = bl;
        this.update();
    }

    public void debugSymmetry() {
        System.out.println("Arrays.asList( getSlitAreas( )) = " + Arrays.asList(this.getSlitAreas()));
        System.out.println("Arrays.asList( getBlockAreas( )) = " + Arrays.asList(this.getBlockAreas()));
    }

    public static interface Listener {
        public void slitChanged();
    }
}

