/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.BoundNode;
import edu.colorado.phet.quantumwaveinterference.davissongermer.ProtractorHandleGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class Protractor
extends PhetPNode {
    LegGraphic leftLeg;
    LegGraphic rightLeg;
    ArcGraphic arcGraphic;
    ReadoutGraphic readoutGraphic;
    ArrayList listeners = new ArrayList();

    public Protractor() {
        this.leftLeg = new LegGraphic();
        this.rightLeg = new LegGraphic();
        this.readoutGraphic = new ReadoutGraphic();
        this.arcGraphic = new ArcGraphic();
        this.addChild(this.leftLeg);
        this.addChild(this.rightLeg);
        this.addChild(this.arcGraphic);
        this.addChild(this.readoutGraphic);
        this.readoutGraphic.setOffset(20.0, -50.0);
        this.leftLeg.setAngle(1.5707963267948966);
        this.rightLeg.setAngle(0.0);
        this.update();
        this.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Protractor.this.notifyVisibilityChanged();
            }
        });
    }

    private void notifyVisibilityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.visibilityChanged(this);
        }
    }

    private void notifyAngleChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.angleChanged(this);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void setLeftLegPickable(boolean bl) {
        this.leftLeg.setPickable(bl);
        this.leftLeg.setChildrenPickable(bl);
    }

    public void setReadoutGraphicPickable(boolean bl) {
        this.readoutGraphic.setPickable(bl);
        this.readoutGraphic.setChildrenPickable(bl);
    }

    private static double toDegrees(double d) {
        return d * 360.0 / Math.PI / 2.0;
    }

    public double getAngle() {
        return this.leftLeg.getAngle() - this.rightLeg.getAngle();
    }

    private void update() {
        this.leftLeg.update();
        this.rightLeg.update();
        this.arcGraphic.update();
        this.readoutGraphic.update();
        this.notifyAngleChanged();
    }

    public double getDegreesUnsigned() {
        return Math.abs(this.getDegreesSigned());
    }

    public double getDegreesSigned() {
        double d = 57.29577951308232 * this.getAngle();
        if (d >= 180.0 && d <= 270.0) {
            d = -(360.0 - d);
        } else if (d < 0.0) {
            // empty if block
        }
        return d;
    }

    class ArcGraphic
    extends PNode {
        private PPath path = new PPath();

        public ArcGraphic() {
            this.path.setStroke(new BasicStroke(5.0f, 0, 0, 1.0f));
            this.path.setStrokePaint(Color.green);
            this.addChild(this.path);
        }

        public void update() {
            double d = 30.0;
            Arc2D.Double double_ = new Arc2D.Double(-d, -d, d * 2.0, d * 2.0, Protractor.toDegrees(0.0), Protractor.toDegrees(0.0), 0);
            Point2D.Double double_2 = Vector2D.parseAngleAndMagnitude(20.0, Protractor.this.leftLeg.getAngle()).getDestination(new Point2D.Double());
            Point2D.Double double_3 = Vector2D.parseAngleAndMagnitude(20.0, Protractor.this.rightLeg.getAngle()).getDestination(new Point2D.Double());
            if (Protractor.this.getDegreesSigned() >= 0.0) {
                double_.setAngles(double_2, double_3);
            } else {
                double_.setAngles(double_3, double_2);
            }
            this.path.setPathTo(double_);
        }
    }

    class LegGraphic
    extends PNode {
        double angle;
        PPath path = new PPath();
        private int LEG_LENGTH = 250;
        ProtractorHandleGraphic protractorHandleGraphic;

        public LegGraphic() {
            this.path.setStrokePaint(Color.orange);
            this.path.setStroke(new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f));
            this.addChild(this.path);
            this.addInputEventListener(new CursorHandler(12));
            this.addInputEventListener(new PDragEventHandler(){

                protected void drag(PInputEvent pInputEvent) {
                    LegGraphic.this.setAngle(LegGraphic.this.getAngle(pInputEvent));
                }
            });
            this.protractorHandleGraphic = new ProtractorHandleGraphic();
            this.addChild(this.protractorHandleGraphic);
            this.update();
        }

        private double getAngle(PInputEvent pInputEvent) {
            Point2D point2D = pInputEvent.getPositionRelativeTo(this.getParent());
            return new Vector2D(new Point2D.Double(), point2D).getAngle();
        }

        private void update() {
            Point2D.Double double_ = Vector2D.parseAngleAndMagnitude(this.LEG_LENGTH, this.angle).getDestination(new Point2D.Double());
            Line2D.Double double_2 = new Line2D.Double(double_, new Point2D.Double());
            this.path.setPathTo(double_2);
            this.protractorHandleGraphic.setOffset(double_);
            this.protractorHandleGraphic.setRotation(this.angle - 1.5707963267948966);
        }

        public double getAngle() {
            return this.angle;
        }

        public void setAngle(double d) {
            this.angle = d;
            Protractor.this.update();
        }
    }

    public static interface Listener {
        public void angleChanged(Protractor var1);

        public void visibilityChanged(Protractor var1);
    }

    class ReadoutGraphic
    extends PNode {
        private DefaultDecimalFormat numberFormat = new DefaultDecimalFormat("0");
        private PText text = new PText();

        public ReadoutGraphic() {
            this.text.setTextPaint(Color.black);
            this.text.setFont(new PhetFont(16, true));
            this.addInputEventListener(new PDragEventHandler(){

                protected void drag(PInputEvent pInputEvent) {
                    PDimension pDimension = pInputEvent.getDeltaRelativeTo(Protractor.this.getParent());
                    Protractor.this.translate(pDimension.getWidth(), pDimension.getHeight());
                }
            });
            BoundNode boundNode = new BoundNode(this.text, 3.0, 3.0);
            boundNode.setPaint(new Color(Color.yellow.getRed(), Color.yellow.getGreen(), Color.yellow.getBlue(), 200));
            this.addChild(boundNode);
            this.addChild(this.text);
            this.addInputEventListener(new CursorHandler());
        }

        public void update() {
            String string = this.numberFormat.format(Protractor.this.getDegreesUnsigned());
            this.text.setText(string + this.getDegreeString());
        }

        private String getDegreeString() {
            return "\u00b0";
        }
    }
}

