/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGIntensityReader;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGModule;
import edu.colorado.phet.quantumwaveinterference.davissongermer.EdgeIntensityReader;
import edu.colorado.phet.quantumwaveinterference.davissongermer.RadialIntensityReader;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DGPlotPanel
extends PSwingCanvas {
    private XYSeriesCollection dataset;
    private int width = 750;
    private int height = 350;
    private DGModule dgModule;
    private XYSeries series;
    private JFreeChartNode jFreeChartNode;
    private IndicatorGraphic indicatorGraphic;
    private JFreeChart chart;
    private DGIntensityReader intensityReader;
    private double indicatorAngle;
    static int savedSeriesIndex = 0;

    public DGPlotPanel(DGModule dGModule) {
        this.dgModule = dGModule;
        this.intensityReader = new EdgeIntensityReader(dGModule.getDGModel());
        this.series = new XYSeries((Comparable)((Object)QWIResources.getString("live.data")));
        this.dataset = new XYSeriesCollection(this.series);
        this.chart = ChartFactory.createScatterPlot(QWIResources.getString("intensity.plot"), QWIResources.getString("angle.degrees"), QWIResources.getString("intensity"), this.dataset, PlotOrientation.VERTICAL, true, false, false);
        this.chart.getXYPlot().getDomainAxis().setRange(0.0, 90.0);
        this.chart.getXYPlot().getRangeAxis().setRange(0.0, 0.1);
        this.chart.getXYPlot().getRangeAxis().setTickLabelsVisible(false);
        this.jFreeChartNode = new JFreeChartNode(this.chart);
        this.jFreeChartNode.setBounds(0.0, 0.0, this.width, this.height);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.getLayer().addChild(this.jFreeChartNode);
        this.setPanEventHandler(null);
        this.setZoomEventHandler(null);
        new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DGPlotPanel.this.replotAll();
            }
        }).start();
        this.indicatorGraphic = new IndicatorGraphic();
        this.getLayer().addChild(this.indicatorGraphic);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                DGPlotPanel.this.updateIndicator();
            }

            public void componentShown(ComponentEvent componentEvent) {
                DGPlotPanel.this.updateIndicator();
            }
        });
    }

    protected void updateIndicator() {
        Point2D point2D = this.jFreeChartNode.plotToNode(new Point2D.Double(this.indicatorAngle, this.chart.getXYPlot().getRangeAxis().getUpperBound()));
        Point2D point2D2 = this.jFreeChartNode.plotToNode(new Point2D.Double(this.indicatorAngle, this.chart.getXYPlot().getRangeAxis().getLowerBound()));
        double d = point2D.getY() - point2D2.getY();
        if (!this.indicatorGraphic.getOffset().equals(point2D2) || this.indicatorGraphic.getIndicatorHeight() != d) {
            this.indicatorGraphic.setOffset(point2D2);
            this.indicatorGraphic.setIndicatorHeight(d);
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            this.repaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void setEdgeIntensityReader() {
        this.intensityReader = new EdgeIntensityReader(this.dgModule.getDGModel());
        this.replotAll();
    }

    public void setRadialIntensityReader() {
        this.intensityReader = new RadialIntensityReader(this.dgModule.getDGModel());
        this.replotAll();
    }

    public void setIndicatorVisible(boolean bl) {
        this.indicatorGraphic.setVisible(bl);
        this.updateIndicator();
    }

    public void setIndicatorAngle(double d) {
        this.indicatorAngle = d;
        this.updateIndicator();
    }

    public boolean isIntensityReaderEdge() {
        return this.intensityReader instanceof EdgeIntensityReader;
    }

    public boolean isIntensityReaderRadial() {
        return this.intensityReader instanceof RadialIntensityReader;
    }

    public void saveDataAsLayer(String string) {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)string), false, true);
        this.copy(this.series, xYSeries);
        this.dataset.addSeries(xYSeries);
        ++savedSeriesIndex;
    }

    private void copy(XYSeries xYSeries, XYSeries xYSeries2) {
        xYSeries2.clear();
        for (int i = 0; i < xYSeries.getItemCount(); ++i) {
            xYSeries2.add(xYSeries.getX(i), xYSeries.getY(i));
        }
    }

    public void clearSnapshots() {
        this.dataset.removeAllSeries();
        this.dataset.addSeries(this.series);
    }

    public void visibilityChanged(boolean bl) {
        this.updateIndicator();
    }

    public void replotAll() {
        this.updateIndicator();
        this.series.clear();
        double d = 1.0;
        for (double d2 = 0.0; d2 <= 90.0; d2 += d) {
            double d3 = this.getIntensity(d2);
            this.series.add(d2, d3);
        }
        this.jFreeChartNode.repaint();
    }

    private double getIntensity(double d) {
        return this.intensityReader.getIntensity(d);
    }

    class IndicatorGraphic
    extends PhetPNode {
        private PPath path = new PPath();
        private double height;

        public IndicatorGraphic() {
            this.setIndicatorHeight(0.0);
            this.addChild(this.path);
        }

        public void setIndicatorHeight(double d) {
            this.height = d;
            this.path.setPathTo(new Line2D.Double(0.0, 0.0, 0.0, d));
        }

        public double getIndicatorHeight() {
            return this.height;
        }
    }
}

