/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.quantumwaveinterference.davissongermer.CircularAtomLattice;
import edu.colorado.phet.quantumwaveinterference.davissongermer.ConcreteAtomLattice;
import edu.colorado.phet.quantumwaveinterference.davissongermer.CoordinateFrame;
import edu.colorado.phet.quantumwaveinterference.davissongermer.FractionalAtomLattice;
import edu.colorado.phet.quantumwaveinterference.davissongermer.SquareAtomLattice;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import java.awt.Point;
import java.util.ArrayList;

public class DGModel {
    private QWIModel QWIModel;
    private FractionalAtomLattice fractionalAtomLattice;
    private ConcreteAtomLattice concreteAtomLattice;
    private ArrayList listeners = new ArrayList();
    private double defaultLatticeY0 = 0.35;
    private static double scaleTx = 0.2222222222222222;
    private CoordinateFrame radiusViewFrame = new CoordinateFrame(0.05, 0.25);
    private CoordinateFrame radiusModelFrame = new CoordinateFrame(this.radiusViewFrame.getMin() * scaleTx, this.radiusViewFrame.getMax() * scaleTx);
    private double DEFAULT_RADIUS = this.radiusViewFrame.transform(0.15, this.radiusModelFrame);
    private CoordinateFrame spacingViewFrame = new CoordinateFrame(0.4, 1.2);
    private CoordinateFrame spacingModelFrame = new CoordinateFrame(this.spacingViewFrame.getMin() * scaleTx, this.spacingViewFrame.getMax() * scaleTx);
    private double DEFAULT_SPACING = this.spacingViewFrame.transform(0.6, this.spacingModelFrame);

    public DGModel(QWIModel qWIModel) {
        this.QWIModel = qWIModel;
        this.concreteAtomLattice = new ConcreteAtomLattice(qWIModel.getGridWidth(), qWIModel.getGridHeight());
        qWIModel.addPotential(this.concreteAtomLattice);
        this.fractionalAtomLattice = this.createAtomLattice(false);
        this.updatePotential();
        qWIModel.addListener(new QWIModel.Adapter(){

            public void sizeChanged() {
                DGModel.this.updatePotential();
            }
        });
    }

    private FractionalAtomLattice createAtomLattice(boolean bl) {
        return bl ? new CircularAtomLattice(this.DEFAULT_RADIUS, this.DEFAULT_SPACING, this.defaultLatticeY0, 1.7976931348623156E305) : new SquareAtomLattice(this.DEFAULT_RADIUS, this.DEFAULT_SPACING, this.defaultLatticeY0, 1.7976931348623156E305);
    }

    public Wavefunction getWavefunction() {
        return this.QWIModel.getWavefunction();
    }

    public boolean isAtomShapeCircular() {
        return this.fractionalAtomLattice instanceof CircularAtomLattice;
    }

    public boolean isAtomShapeSquare() {
        return this.fractionalAtomLattice instanceof SquareAtomLattice;
    }

    public void setAtomShapeCircular() {
        this.fractionalAtomLattice = this.createAtomLattice(true);
        this.updatePotential();
    }

    public void setAtomShapeSquare() {
        this.fractionalAtomLattice = this.createAtomLattice(false);
        this.updatePotential();
    }

    public Point getCenterAtomPoint() {
        return this.fractionalAtomLattice.getCenterAtomConcretePoint(this.QWIModel.getGridWidth(), this.QWIModel.getGridHeight());
    }

    public CoordinateFrame getRadiusModelFrame() {
        return this.radiusModelFrame;
    }

    public CoordinateFrame getRadiusViewFrame() {
        return this.radiusViewFrame;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void setFractionalSpacing(double d) {
        this.clearWave();
        this.fractionalAtomLattice.setSpacing(d);
        this.updatePotential();
    }

    private void clearWave() {
        this.QWIModel.clearWavefunction();
    }

    private void updatePotential() {
        this.QWIModel.removePotential(this.concreteAtomLattice);
        this.concreteAtomLattice = this.fractionalAtomLattice.toConcreteAtomLattice(this.QWIModel.getGridWidth(), this.QWIModel.getGridHeight());
        this.QWIModel.addPotential(this.concreteAtomLattice);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.potentialChanged();
        }
    }

    public void setFractionalRadius(double d) {
        this.clearWave();
        this.fractionalAtomLattice.setAtomRadius(d);
        this.updatePotential();
    }

    public double getFractionalRadius() {
        return this.fractionalAtomLattice.getAtomRadius();
    }

    public double getFractionalSpacing() {
        return this.fractionalAtomLattice.getSpacingBetweenAtoms();
    }

    public ConcreteAtomLattice getConcreteAtomLattice() {
        return this.concreteAtomLattice;
    }

    public CoordinateFrame getSpacingModelFrame() {
        return this.spacingModelFrame;
    }

    public CoordinateFrame getSpacingViewFrame() {
        return this.spacingViewFrame;
    }

    static interface Listener {
        public void potentialChanged();
    }
}

